/*
 * Decompiled with CFR 0.152.
 */
package tech.nmfin.portfoliooptimization.socp.constraints;

import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.CSRSparseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.MatrixCoordinate;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.SOCPLinearInequalities;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.SOCPLinearInequality;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.portfoliooptimization.SOCPPortfolioConstraint;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SOCPLinearMaximumLoan
extends SOCPPortfolioConstraint {
    private final int void;
    private final Vector class;
    private final double goto;
    public static final double DEFAULT_EPSILON = 1.0E-6;
    private final Vector enum;

    @Override
    public int dimensionOfRange() {
        return 1;
    }

    static {
        Package.validate("ALGOQUANT_SOCP_CONSTRAINTS");
    }

    @Override
    public Double evaluate(Vector y) {
        Vector a2 = y.minus(this.enum);
        double a3 = 0.0;
        for (int a4 = 1; a4 <= this.void; ++a4) {
            double a5 = a2.get(a4) + Math.max(0.0, this.enum.get(a4));
            double a6 = a5 - this.class.get(a4);
            a3 += a6;
        }
        return a3;
    }

    public SOCPLinearMaximumLoan(Vector w0, Vector l2, double epsilon) {
        ArgumentAssertion.assertTrue(w0.size() == l2.size(), "w0's size (%d) must match l's size (%d)", w0.size(), l2.size());
        this.enum = w0;
        this.void = w0.size();
        this.class = l2;
        this.goto = epsilon;
        SOCPLinearInequalities a3 = this.newSOCPLinearInequalities(new SOCPPortfolioConstraint.Variable("y", this.void));
        List<SparseMatrix.Entry> a4 = IntStream.rangeClosed(1, this.void).mapToObj(a2 -> new SparseMatrix.Entry(new MatrixCoordinate(a2, a2), -1.0)).collect(Collectors.toList());
        CSRSparseMatrix a6 = new CSRSparseMatrix(this.void, this.void, a4);
        SparseVector a7 = new SparseVector(this.void);
        IntStream.rangeClosed(1, this.void).forEach(a5 -> a7.set(a5, (Math.abs(w0.get(a5)) - w0.get(a5)) / 2.0 - l2.get(a5)));
        a3.add(new SOCPLinearInequality(a6, a7));
    }

    public SOCPLinearMaximumLoan(Vector w0, Vector l2) {
        this(w0, l2, 1.0E-6);
    }

    @Override
    public int dimensionOfDomain() {
        return this.void;
    }

    @Override
    public boolean areAllConstraintsSatisfied(Vector y) throws SOCPPortfolioConstraint.ConstraintViolationException {
        for (int a2 = 1; a2 <= this.void; ++a2) {
            double a3 = y.get(a2) + Math.max(0.0, this.enum.get(a2));
            if (DoubleUtils.compare(a3, this.class.get(a2), this.goto) <= 0) continue;
            throw new SOCPPortfolioConstraint.ConstraintViolationException(String.format("borrowing (%f) more than allowed (%f) for asset %d: %s", a3, this.class.get(a2), a2, y));
        }
        return true;
    }
}

