/*
 * Decompiled with CFR 0.152.
 */
package tech.nmfin.portfoliooptimization.markowitz;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.CSRSparseMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.positivedefinite.PositiveDefiniteMatrixByPositiveDiagonal;
import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.analysis.function.rn2r1.QuadraticFunction;
import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import dev.nm.analysis.root.univariate.BrentRoot;
import dev.nm.analysis.root.univariate.NoRootFoundException;
import dev.nm.misc.PrecisionUtils;
import dev.nm.number.DoubleUtils;
import dev.nm.root.univariate.GridSearchMinimizer;
import dev.nm.root.univariate.UnivariateMinimizer;
import dev.nm.root.univariate.bracketsearch.BrentMinimizer;
import dev.nm.solver.IterativeSolution;
import dev.nm.solver.multivariate.constrained.constraint.linear.LinearConstraints;
import dev.nm.solver.multivariate.constrained.constraint.linear.LinearEqualityConstraints;
import dev.nm.solver.multivariate.constrained.constraint.linear.LinearGreaterThanConstraints;
import dev.nm.solver.multivariate.constrained.constraint.linear.LinearLessThanConstraints;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.qp.QPInfeasible;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.qp.QPSimpleMinimizer;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.qp.QPSolution;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.qp.problem.QPProblem;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.qp.solver.socp.QPbySOCPMinimizer1;
import tech.nmfin.portfoliooptimization.PortfolioUtils;
import tech.nmfin.portfoliooptimization.markowitz.constraints.QPConstraint;
import tech.nmfin.portfoliooptimization.markowitz.constraints.QPUnity;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MarkowitzByQP {
    private final LinearGreaterThanConstraints super;
    private Vector final;
    private double break = Double.NaN;
    private final UnivariateRealFunction else = new AbstractUnivariateRealFunction(){

        @Override
        public double evaluate(double q) {
            double a2;
            try {
                Vector a3 = MarkowitzByQP.this.getOptimalW(q);
                a2 = PortfolioUtils.getSharpeRatio(a3, MarkowitzByQP.this.catch, MarkowitzByQP.this.goto, MarkowitzByQP.this.class);
            }
            catch (Exception a4) {
                a2 = Double.NEGATIVE_INFINITY;
            }
            return -a2;
        }
        {
            1 a3;
        }
    };
    private final Vector catch;
    private final LinearLessThanConstraints const;
    private final LinearEqualityConstraints void;
    private final double class;
    private final Matrix goto;
    private final double enum;

    private Vector do(double a2) throws Exception {
        MarkowitzByQP a3;
        Matrix a4;
        Matrix a5 = a4 = a3.goto.scaled(2.0 * a2);
        double a6 = PrecisionUtils.autoEpsilon(a4);
        if (!MatrixPropertyUtils.isPositiveDefinite(a4, a6)) {
            a5 = new PositiveDefiniteMatrixByPositiveDiagonal(a4, a6, a6);
        }
        Vector a7 = a3.catch.scaled(-1.0);
        QuadraticFunction a8 = new QuadraticFunction(a5, a7);
        if (a3.super == null && a3.const == null) {
            return QPSimpleMinimizer.solve(a8, a3.void, a6).minimizer();
        }
        QPProblem a9 = new QPProblem(a8, a3.void, a3.super, a3.const);
        QPbySOCPMinimizer1 a10 = new QPbySOCPMinimizer1(a6, 10000);
        IterativeSolution a11 = (IterativeSolution)a10.solve(a9);
        QPSolution a12 = a11.search(new QPSolution[0]);
        return a12.minimizer();
    }

    public MarkowitzByQP(Vector mu, Matrix sigma, Vector lower, Vector upper, double benchmarkRate) {
        LinearEqualityConstraints a2;
        this.enum = 100.0 * PrecisionUtils.autoEpsilon(sigma);
        this.catch = new ImmutableVector(mu);
        this.goto = new ImmutableMatrix(sigma);
        this.class = benchmarkRate;
        int a3 = mu.size();
        Matrix a4 = new CSRSparseMatrix(a3, a3).ONE();
        this.super = new LinearGreaterThanConstraints(a4, lower);
        this.const = new LinearLessThanConstraints(a4, upper);
        this.void = a2 = new QPUnity(mu.size()).linearEqualityConstraints();
    }

    protected Vector getOptimalW(double q) throws Exception {
        return this.do(q);
    }

    public MarkowitzByQP(Vector mu, Matrix sigma) {
        this(mu, sigma, new DenseVector(mu.size(), 0.0), new DenseVector(mu.size(), 1.01));
    }

    public Vector getOptimalWeights() {
        return this.final;
    }

    public MarkowitzByQP(Vector mu, Matrix sigma, Vector lower, Vector upper) {
        this(mu, sigma, lower, upper, 0.0);
    }

    public MarkowitzByQP(Vector mu, Matrix sigma, QPConstraint constraints, double benchmarkRate) {
        this.enum = 100.0 * PrecisionUtils.autoEpsilon(sigma);
        this.catch = new ImmutableVector(mu);
        this.goto = new ImmutableMatrix(sigma);
        this.class = benchmarkRate;
        this.super = constraints.linearGreaterThanConstraints();
        this.const = constraints.linearLessThanConstraints();
        LinearEqualityConstraints a2 = constraints.linearEqualityConstraints();
        LinearEqualityConstraints a3 = new QPUnity(mu.size()).linearEqualityConstraints();
        this.void = a2 != null ? (LinearEqualityConstraints)LinearConstraints.concat(a3, a2) : a3;
    }

    public void setRiskAversionCoefficient(double q) throws QPInfeasible, Exception {
        this.break = q;
        this.final = new ImmutableVector(this.getOptimalW(q));
    }

    public double getOptimalRiskAversionCoefficient() {
        double a2 = 1.0E-6;
        double a3 = 10.0;
        int a4 = 50;
        double a5 = (a3 - a2) / (double)a4;
        GridSearchMinimizer a6 = new GridSearchMinimizer(a4);
        GridSearchMinimizer.Solution a7 = a6.solve(this.else);
        double a8 = a7.search(a2, a3);
        try {
            if (DoubleUtils.compare(a8, a2, a5 / 2.0) == 0) {
                return a2;
            }
            if (DoubleUtils.compare(a8, a3, a5 / 2.0) == 0) {
                return a3;
            }
            return this.getOptimalRiskAversionCoefficient(a2, a8, a3);
        }
        catch (Exception a9) {
            return a8;
        }
    }

    public double fw() {
        Matrix a2 = this.goto.scaled(2.0 * this.break);
        Vector a3 = this.catch.scaled(-1.0);
        QuadraticFunction a4 = new QuadraticFunction(a2, a3);
        double a5 = a4.evaluate(this.final);
        return a5;
    }

    public double getRiskAversionCoefficientForTargetReturn(final double r, double lower, double upper, int maxIterations) throws NoRootFoundException {
        AbstractUnivariateRealFunction a2 = new AbstractUnivariateRealFunction(){
            {
                2 a3;
            }

            @Override
            public double evaluate(double q) {
                double a2;
                try {
                    Vector a3 = MarkowitzByQP.this.getOptimalW(q);
                    double a4 = PortfolioUtils.getPortfolioReturns(a3, MarkowitzByQP.this.catch);
                    a2 = a4 - r;
                }
                catch (Exception a5) {
                    a2 = Double.NEGATIVE_INFINITY;
                }
                return a2;
            }
        };
        BrentRoot a3 = new BrentRoot(this.enum, maxIterations);
        double a4 = a3.solve(a2, lower, upper, r);
        return a4;
    }

    public double getOptimalRiskAversionCoefficient(double lower, double initial, double upper) throws Exception {
        BrentMinimizer a2 = new BrentMinimizer(1.0E-15, 4);
        UnivariateMinimizer.Solution a3 = a2.solve(this.else);
        double a4 = a3.search(lower, initial, upper);
        return a4;
    }

    public MarkowitzByQP(Vector mu, Matrix sigma, QPConstraint constraints) {
        this(mu, sigma, constraints, 0.0);
    }

    public double getRiskAversionCoefficientForTargetVariance(final double var, double lower, double upper, int maxIterations) throws NoRootFoundException {
        AbstractUnivariateRealFunction a2 = new AbstractUnivariateRealFunction(){

            @Override
            public double evaluate(double q) {
                double a2;
                try {
                    Vector a3 = MarkowitzByQP.this.getOptimalW(q);
                    double a4 = PortfolioUtils.getPortfolioVariance(a3, MarkowitzByQP.this.goto);
                    a2 = a4 - var;
                }
                catch (Exception a5) {
                    a2 = Double.NEGATIVE_INFINITY;
                }
                return a2;
            }
            {
                3 a3;
            }
        };
        BrentRoot a3 = new BrentRoot(this.enum, maxIterations);
        double a4 = a3.solve(a2, lower, upper, var);
        return a4;
    }
}

