/*
 * Decompiled with CFR 0.152.
 */
package tech.nmfin.meanreversion.volarb;

import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import java.time.LocalDateTime;
import tech.nmfin.meanreversion.volarb.MeanPriceEstimator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MeanEstimatorMaxLevelShift
implements MeanPriceEstimator {
    private final double const;
    private final double void;
    private double class;
    private final double goto;
    private final int enum;

    @Override
    public double mean() {
        return this.class;
    }

    static {
        Package.validate("ALGOQUANT_VOLARB");
    }

    public MeanEstimatorMaxLevelShift(int maxLevel, double gridSize, double precision) {
        this(maxLevel, gridSize, precision, Double.NaN);
    }

    @Override
    public void update(LocalDateTime now, double px) {
        double a2;
        double a3;
        if (Double.isNaN(this.class)) {
            this.class = px;
        }
        if (DoubleUtils.compare(a3 = Math.abs(a2 = px - this.class), this.void + this.const, this.goto) > 0) {
            int a4 = (int)Math.floor((a3 - this.void) / this.const - this.goto);
            double a5 = this.const * (double)a4;
            this.class += Math.signum(a2) * a5;
        }
    }

    public MeanEstimatorMaxLevelShift(int maxLevel, double gridSize, double precision, double mean) {
        this.enum = maxLevel;
        this.const = gridSize;
        this.goto = precision;
        this.class = mean;
        this.void = (double)maxLevel * gridSize;
    }

    public String toString() {
        return String.format("[%s (maxLevel=%d, gridSize=%f, precision=%f, mean=%f)]", this.getClass().getSimpleName(), this.enum, this.const, this.goto, this.class);
    }
}

