/*
 * Decompiled with CFR 0.152.
 */
package tech.nmfin.meanreversion.cointegration.check;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.operation.VectorFactory;
import dev.nm.misc.Constants;
import dev.nm.stat.descriptive.correlation.CorrelationMatrix;
import dev.nm.stat.descriptive.covariance.SampleCovariance;
import tech.nmfin.meanreversion.cointegration.NoPairFoundException;
import tech.nmfin.meanreversion.cointegration.PairingModelUtils;
import tech.nmfin.meanreversion.cointegration.check.PairingCheck;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CorrelationCheck
implements PairingCheck {
    private final double void;
    private final double class;
    private final double goto;
    private final Matrix enum;

    public static double cor(Matrix A2, double tailed) {
        Matrix a2 = PairingModelUtils.getTailedMatrix(A2, tailed);
        SampleCovariance a3 = new SampleCovariance(a2);
        Vector a4 = VectorFactory.diagonal(a3);
        double a5 = 0.0;
        if (a4.norm() > Constants.EPSILON) {
            CorrelationMatrix a6 = new CorrelationMatrix((Matrix)a3);
            a5 = a6.get(1, 2);
        }
        return a5;
    }

    @Override
    public boolean isOK() throws NoPairFoundException {
        double a2 = CorrelationCheck.cor(this.enum, this.class);
        if (a2 < this.void) {
            throw new NoPairFoundException("cor too small");
        }
        if (a2 > this.goto) {
            throw new NoPairFoundException("cor too big");
        }
        return true;
    }

    public CorrelationCheck(Matrix A2, double tail, double lowerBound, double upperBound) {
        this.enum = A2;
        this.class = tail;
        this.void = lowerBound;
        this.goto = upperBound;
    }

    public CorrelationCheck(Matrix A2, double lowerBound, double upperBound) {
        this(A2, 1.0, lowerBound, upperBound);
    }
}

