/*
 * Decompiled with CFR 0.152.
 */
package tech.nmfin.meanreversion.cointegration;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixFactory;
import dev.nm.algebra.linear.matrix.doubles.operation.SubMatrixRef;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import dev.nm.stat.cointegration.CointegrationMLE;
import dev.nm.stat.cointegration.JohansenAsymptoticDistribution;
import dev.nm.stat.cointegration.JohansenTest;
import dev.nm.stat.timeseries.datastructure.multivariate.realtime.inttime.MultivariateSimpleTimeSeries;
import java.util.ArrayList;
import java.util.List;
import tech.nmfin.meanreversion.cointegration.NoPairFoundException;
import tech.nmfin.meanreversion.cointegration.TradingPair;
import tech.nmfin.meanreversion.cointegration.check.PairingCheck;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RobustCointegration {
    private final List<PairingCheck> goto = new ArrayList<PairingCheck>();
    private static final JohansenTest enum;
    protected static final double REMAINING_ROWS_PCT_THRESHOLD = 0.8;

    public TradingPair computeRobustPair(String symbol1, String symbol2, Vector price1, Vector price2) throws NoPairFoundException {
        Matrix a2 = MatrixFactory.cbind(price1, price2);
        Matrix a3 = RobustCointegration.filterPrices(a2);
        for (PairingCheck a4 : this.goto) {
            a4.isOK();
        }
        double a5 = RobustCointegration.computeCointegratingBeta(a3);
        if (Double.isNaN(a5)) {
            throw new NoPairFoundException(String.format("%s/%s not cointegrated in the first test", symbol1, symbol2));
        }
        double a6 = RobustCointegration.computeShortTermCointegratingBeta(a3, 0.5);
        if (Double.isNaN(a6)) {
            throw new NoPairFoundException(String.format("%s/%s not cointegrated in the second test", symbol1, symbol2));
        }
        if (Math.abs((a6 - a5) / a5) > 0.2) {
            throw new NoPairFoundException(String.format("%s/%s no stable cointegration", symbol1, symbol2));
        }
        return new TradingPair(symbol1, symbol2, price1, price2, (a6 + a5) / 2.0);
    }

    public void addCheck(PairingCheck check) {
        this.goto.add(check);
    }

    protected static Matrix filterUnchangedPrices(Matrix prices0) throws NoPairFoundException {
        int a2;
        ArrayList<double[]> a3 = new ArrayList<double[]>();
        a3.add(new double[]{prices0.get(1, 1), prices0.get(1, 2)});
        int a4 = prices0.nRows();
        for (a2 = 2; a2 <= a4; ++a2) {
            if (DoubleUtils.equal(prices0.get(a2, 1), prices0.get(a2 - 1, 1), 1.0E-6) && DoubleUtils.equal(prices0.get(a2, 2), prices0.get(a2 - 1, 2), 1.0E-6)) continue;
            a3.add(new double[]{prices0.get(a2, 1), prices0.get(a2, 2)});
        }
        a2 = a3.size();
        double[][] a5 = new double[a2][2];
        for (int a6 = 0; a6 < a3.size(); ++a6) {
            a5[a6][0] = ((double[])a3.get(a6))[0];
            a5[a6][1] = ((double[])a3.get(a6))[1];
        }
        double a7 = (double)a2 / (double)a4;
        if (a7 < 0.8) {
            throw new NoPairFoundException(String.format("not enough data in the filtered time series", new Object[0]));
        }
        return new DenseMatrix(a5);
    }

    protected static double computeCointegratingBeta(Matrix prices) {
        MultivariateSimpleTimeSeries a2 = new MultivariateSimpleTimeSeries(prices);
        CointegrationMLE a3 = new CointegrationMLE(a2, false, 2);
        int a4 = enum.r(a3, 0.1);
        Vector a5 = a4 > 0 ? a3.beta(1) : null;
        double a6 = a5 != null ? a5.get(2) : Double.NaN;
        return a6;
    }

    protected static Matrix filterPrices(Matrix prices0) throws NoPairFoundException {
        Matrix a2 = RobustCointegration.filterUnchangedPrices(prices0);
        return a2;
    }

    protected static double computeShortTermCointegratingBeta(Matrix prices, double tailed) {
        Matrix a2 = RobustCointegration.getTailedMatrix(prices, tailed);
        double a3 = RobustCointegration.computeCointegratingBeta(a2);
        return a3;
    }

    protected static Matrix getTailedMatrix(Matrix A2, double tailed) {
        int a2 = A2.nRows();
        SubMatrixRef a3 = new SubMatrixRef(A2, (int)((double)a2 * (1.0 - tailed)), a2, 1, A2.nCols());
        return a3;
    }

    static {
        Package.validate("ALGOQUANT_COINTEGRATION");
        enum = new JohansenTest(JohansenAsymptoticDistribution.Test.EIGEN, JohansenAsymptoticDistribution.TrendType.NO_CONSTANT, 2);
    }
}

