/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.timeseries.linear.univariate.stationaryprocess.garch;

import dev.nm.analysis.function.tuple.Pair;
import dev.nm.number.DoubleUtils;
import dev.nm.stat.random.rng.univariate.RandomNumberGenerator;
import dev.nm.stat.random.rng.univariate.normal.StandardNormalRNG;
import dev.nm.stat.timeseries.linear.univariate.stationaryprocess.garch.GARCHModel;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GARCHSim
implements RandomNumberGenerator {
    private final RandomNumberGenerator void;
    private final GARCHModel class;
    private double[] goto;
    private double[] enum;

    public GARCHSim(GARCHModel model, RandomNumberGenerator rng) {
        this(model, DoubleUtils.rep(0.0, model.q()), rng);
    }

    public Pair nextPair() {
        double a2 = this.class.sigma2(this.goto, this.enum);
        double a3 = this.void.nextDouble();
        double a4 = Math.sqrt(a2) * a3;
        if (this.enum.length > 0) {
            DoubleUtils.rightShift(this.enum);
            this.enum[0] = a2;
        }
        if (this.goto.length > 0) {
            DoubleUtils.rightShift(this.goto);
            this.goto[0] = a4 * a4;
        }
        return new Pair(a4, a2);
    }

    public GARCHSim(GARCHModel model) {
        this(model, new StandardNormalRNG());
    }

    public GARCHSim(GARCHModel model, double[] z, RandomNumberGenerator rng) {
        this.class = model;
        this.void = rng;
        double a2 = model.var();
        this.enum = DoubleUtils.rep(a2, model.p());
        this.goto = Arrays.copyOfRange(z, 0, model.q());
        int a3 = 0;
        while (a3 < model.q()) {
            int n = a3++;
            this.goto[n] = this.goto[n] * a2;
        }
    }

    @Override
    public double nextDouble() {
        return this.nextPair().x();
    }

    @Override
    public void seed(long ... seeds) {
        this.void.seed(seeds);
    }
}

