/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.timeseries.linear.univariate.arima;

import dev.nm.number.DoubleUtils;
import dev.nm.stat.random.rng.univariate.RandomNumberGenerator;
import dev.nm.stat.random.rng.univariate.normal.StandardNormalRNG;
import dev.nm.stat.timeseries.linear.univariate.arima.ARIMAModel;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ARIMASim
implements RandomNumberGenerator {
    private double[] const;
    private final ARIMAModel void;
    private double[] class;
    private final RandomNumberGenerator goto;
    private double[] enum;

    public ARIMASim(ARIMAModel arima) {
        this(arima, new StandardNormalRNG());
    }

    @Override
    public void seed(long ... seeds) {
        this.goto.seed(seeds);
    }

    public ARIMASim(ARIMAModel arima, double[] lags, double[] innovations, RandomNumberGenerator rng) {
        this.void = arima;
        this.enum = Arrays.copyOf(lags, arima.p());
        this.class = Arrays.copyOf(innovations, arima.q());
        this.const = new double[arima.d() + 1];
        if (lags != null && lags.length > 0) {
            this.const[0] = lags[0];
            double[] a2 = DoubleUtils.reverseCopy(lags);
            for (int a3 = 1; a3 <= arima.d(); ++a3) {
                a2 = DoubleUtils.cumsum(a2);
                this.const[a3] = a2[a2.length - 1];
            }
        }
        this.goto = rng;
    }

    public ARIMASim(ARIMAModel arima, RandomNumberGenerator rng) {
        this(arima, DoubleUtils.rep(0.0, arima.p()), DoubleUtils.rep(0.0, arima.q()), rng);
    }

    @Override
    public double nextDouble() {
        double a2;
        double a3 = this.goto.nextDouble() * this.void.sigma();
        this.const[0] = a2 = this.void.getARMA().conditionalMean(this.enum, this.class) + a3;
        for (int a4 = 1; a4 <= this.void.d(); ++a4) {
            int n = a4;
            this.const[n] = this.const[n] + this.const[a4 - 1];
        }
        if (this.enum.length > 0) {
            DoubleUtils.rightShift(this.enum);
            this.enum[0] = a2;
        }
        if (this.class.length > 0) {
            DoubleUtils.rightShift(this.class);
            this.class[0] = a3;
        }
        return this.const[this.void.d()];
    }
}

