/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.timeseries.linear.multivariate.stationaryprocess.arma;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.Inverse;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.number.DoubleUtils;
import dev.nm.stat.timeseries.linear.multivariate.arima.VARIMAModel;
import dev.nm.stat.timeseries.linear.univariate.stationaryprocess.arma.ARMAModel;
import java.util.Arrays;

public class VARMAModel
extends VARIMAModel {
    public VARMAModel(Vector mu, Matrix[] phi, Matrix[] theta) {
        this(mu, phi, theta, (Matrix)new DenseMatrix(mu.size(), mu.size()).ONE());
    }

    public VARMAModel(VARMAModel that) {
        super(that);
    }

    public VARMAModel(Vector mu, Matrix[] phi, Matrix[] theta, Matrix sigma) {
        super(mu, phi, 0, theta, sigma);
    }

    public VARMAModel(ARMAModel model) {
        super(model);
    }

    public Vector unconditionalMean() {
        int a2 = this.p();
        if (a2 == 0) {
            return this.mu();
        }
        Matrix a3 = this.AR(1);
        for (int a4 = 2; a4 <= a2; ++a4) {
            a3 = a3.add(this.AR(a4));
        }
        Matrix a5 = a3.ONE().minus(a3);
        a5 = new Inverse(a5);
        Vector a6 = a5.multiply(this.mu());
        return a6;
    }

    public VARMAModel(Matrix[] phi, Matrix[] theta, Matrix sigma) {
        this((Vector)new DenseVector(DoubleUtils.rep(0.0, sigma.nRows())), phi, theta, sigma);
    }

    public VARMAModel getDemeanedModel() {
        ImmutableMatrix[] a2 = this.phi();
        ImmutableMatrix[] a3 = this.theta();
        return new VARMAModel(Arrays.copyOfRange(a2, 1, a2.length), Arrays.copyOfRange(a3, 1, a3.length));
    }

    public VARMAModel(Matrix[] phi, Matrix[] theta) {
        this(phi, theta, (Matrix)new DenseMatrix(phi != null ? phi[0].nRows() : theta[0].nRows(), phi != null ? phi[0].nRows() : theta[0].nRows()).ONE());
    }

    public Vector conditionalMean(Matrix arLags, Matrix maLags) {
        int a2;
        int a3 = this.dimension();
        Matrix a4 = new DenseMatrix(DoubleUtils.rep(0.0, a3), a3, 1);
        Matrix a5 = new DenseMatrix(DoubleUtils.rep(0.0, a3), a3, 1);
        if (this.p() > 0) {
            for (a2 = 1; a2 <= this.p(); ++a2) {
                a4 = a4.add(this.AR(a2).multiply(new DenseMatrix(arLags.getColumn(a2).toArray(), a3, 1)));
            }
        }
        if (this.q() > 0) {
            for (a2 = 1; a2 <= this.q(); ++a2) {
                a5 = a5.add(this.MA(a2).multiply(new DenseMatrix(maLags.getColumn(a2).toArray(), a3, 1)));
            }
        }
        Matrix a6 = a4.add(a5);
        Matrix a7 = new DenseMatrix(this.mu()).add(a6);
        return a7.getColumn(1);
    }
}

