/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.timeseries.linear.multivariate.arima;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import dev.nm.stat.timeseries.linear.multivariate.stationaryprocess.arma.VARMAXModel;
import dev.nm.stat.timeseries.linear.univariate.arima.ARIMAXModel;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class VARIMAXModel {
    private final ImmutableMatrix catch;
    private final ImmutableVector const;
    private final ImmutableMatrix[] void;
    private final int class;
    private final ImmutableMatrix goto;
    private final ImmutableMatrix[] enum;

    public ImmutableMatrix psi() {
        return this.catch != null ? this.catch : null;
    }

    public int dimension() {
        return this.const.size();
    }

    public VARIMAXModel(VARIMAXModel that) {
        this.const = new ImmutableVector(new DenseVector(that.const));
        this.void = Arrays.copyOf(that.void, that.void.length);
        this.enum = Arrays.copyOf(that.enum, that.enum.length);
        this.catch = that.catch != null ? new ImmutableMatrix(new DenseMatrix(that.catch)) : null;
        this.class = that.class;
        this.goto = new ImmutableMatrix(new DenseMatrix(that.goto));
    }

    public ImmutableMatrix sigma() {
        return this.goto;
    }

    public ImmutableMatrix AR(int i2) {
        return i2 <= this.p() ? this.void[i2] : new ImmutableMatrix(this.void[0].ZERO());
    }

    public VARIMAXModel(Matrix[] phi, int d2, Matrix[] theta, Matrix psi) {
        this(phi, d2, theta, psi, (Matrix)new DenseMatrix(phi != null ? phi[0].nRows() : theta[0].nRows(), phi != null ? phi[0].nRows() : theta[0].nRows()).ONE());
    }

    public VARIMAXModel(Vector mu, Matrix[] phi, int d2, Matrix[] theta, Matrix psi) {
        this(mu, phi, d2, theta, psi, (Matrix)new DenseMatrix(mu.size(), mu.size()).ONE());
    }

    public VARIMAXModel(ARIMAXModel model) {
        int a2;
        this.const = new ImmutableVector(new DenseVector(DoubleUtils.rep(model.mu(), 1)));
        this.class = model.d();
        this.goto = new ImmutableMatrix(new DenseMatrix(new double[]{model.sigma()}, 1, 1));
        int a3 = model.p();
        int a4 = model.q();
        this.void = new ImmutableMatrix[a3 + 1];
        for (a2 = 0; a2 <= a3; ++a2) {
            this.void[a2] = new ImmutableMatrix(new DenseMatrix(new double[]{model.AR(a2)}, 1, 1));
        }
        this.enum = new ImmutableMatrix[a4 + 1];
        for (a2 = 0; a2 <= a4; ++a2) {
            this.enum[a2] = new ImmutableMatrix(new DenseMatrix(new double[]{model.MA(a2)}, 1, 1));
        }
        this.catch = model.psi() != null ? new ImmutableMatrix(new DenseMatrix(model.psi(), 1, model.psi().length)) : null;
    }

    public VARIMAXModel(Matrix[] phi, int d2, Matrix[] theta, Matrix psi, Matrix sigma) {
        this(new DenseVector(DoubleUtils.rep(0.0, sigma.nRows())), phi, d2, theta, psi, sigma);
    }

    public ImmutableVector mu() {
        return this.const;
    }

    public int q() {
        return this.enum.length - 1;
    }

    public ImmutableMatrix[] phi() {
        return this.void;
    }

    public ImmutableMatrix[] theta() {
        return this.enum;
    }

    public VARIMAXModel(Vector mu, Matrix[] phi, int d2, Matrix[] theta, Matrix psi, Matrix sigma) {
        int a2;
        ArgumentAssertion.assertNonNegative(d2, "d");
        this.class = d2;
        this.const = new ImmutableVector(mu);
        int a3 = mu.size();
        this.void = new ImmutableMatrix[phi != null ? phi.length + 1 : 1];
        this.void[0] = new ImmutableMatrix((Matrix)new DenseMatrix(a3, a3).ONE());
        if (phi != null) {
            for (a2 = 0; a2 < phi.length; ++a2) {
                ArgumentAssertion.assertTrue(phi[a2].nRows() == a3 && phi[a2].nCols() == a3, "each AR coefficient should be a square matrix of the correct dimension", new Object[0]);
                this.void[a2 + 1] = new ImmutableMatrix(phi[a2]);
            }
        }
        this.enum = new ImmutableMatrix[theta != null ? theta.length + 1 : 1];
        this.enum[0] = new ImmutableMatrix((Matrix)new DenseMatrix(a3, a3).ONE());
        if (theta != null) {
            for (a2 = 0; a2 < theta.length; ++a2) {
                ArgumentAssertion.assertTrue(theta[a2].nRows() == a3 && theta[a2].nCols() == a3, "each MA coefficient should be a square matrix of the correct dimension", new Object[0]);
                this.enum[a2 + 1] = new ImmutableMatrix(theta[a2]);
            }
        }
        if (psi != null) {
            ArgumentAssertion.assertTrue(psi.nRows() == a3, "number of rows of psi should be the same as the dimension of the multivariate ARIMA model", new Object[0]);
            this.catch = new ImmutableMatrix(psi);
        } else {
            this.catch = null;
        }
        ArgumentAssertion.assertTrue(sigma.nRows() == a3 && sigma.nCols() == a3, "sigma should be a square matrix of the correct dimension", new Object[0]);
        this.goto = new ImmutableMatrix(sigma);
    }

    public int d() {
        return this.class;
    }

    public int p() {
        return this.void.length - 1;
    }

    public int maxPQ() {
        return Math.max(this.p(), this.q());
    }

    public ImmutableMatrix MA(int i2) {
        return i2 <= this.q() ? this.enum[i2] : new ImmutableMatrix(this.enum[0].ZERO());
    }

    public VARMAXModel getVARMAX() {
        return new VARMAXModel((Vector)this.const, (Matrix[])Arrays.copyOfRange(this.void, 1, this.void.length), (Matrix[])Arrays.copyOfRange(this.enum, 1, this.enum.length), (Matrix)this.catch, (Matrix)this.goto);
    }

    static {
        Package.validate("NMDEV_STAT");
    }
}

