/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.test.rank.wilcoxon;

import dev.nm.number.DoubleUtils;
import dev.nm.stat.descriptive.rank.Rank;
import dev.nm.stat.distribution.univariate.NormalDistribution;
import dev.nm.stat.distribution.univariate.ProbabilityDistribution;
import dev.nm.stat.test.HypothesisTest;
import dev.nm.stat.test.rank.wilcoxon.WilcoxonRankSumDistribution;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WilcoxonRankSum
extends HypothesisTest {
    private final boolean final;
    private final boolean break;
    private final int else;
    private final WilcoxonRankSumDistribution catch;
    private double const;
    private final ProbabilityDistribution void = new NormalDistribution(0.0, 1.0);
    private final double class;
    private final int goto;
    private final double enum;

    public WilcoxonRankSum(double[] sample1, double[] sample2, double mu) {
        this(sample1, sample2, mu, sample1.length + sample2.length < 50, false);
    }

    @Override
    public double statistics() {
        double a2 = this.const - (double)(this.goto * (this.goto + 1) / 2);
        return a2;
    }

    public WilcoxonRankSum(double[] sample1, double[] sample2, double mu, boolean isExact) {
        this(sample1, sample2, mu, isExact, true);
    }

    public double rightOneSidedPvalue() {
        double a2;
        double a3 = this.statistics();
        if (this.break) {
            a2 = this.catch.rightOneSidedPvalue(a3);
        } else if (this.final) {
            a2 = WilcoxonRankSum.oneSidedPvalue(this.void, (a3 - this.class - 0.5) / this.enum);
        } else {
            double a4 = (a3 - this.class) / this.enum;
            a2 = WilcoxonRankSum.oneSidedPvalue(this.void, a4);
        }
        return a2;
    }

    public double leftOneSidedPvalue() {
        double a2 = this.statistics();
        double a3 = this.break ? this.catch.cdf(a2) : (this.final ? this.void.cdf((a2 - this.class + 0.5) / this.enum) : 1.0 - this.rightOneSidedPvalue());
        return a3;
    }

    @Override
    public String getAlternativeHypothesis() {
        return "the means are different (not by mu)";
    }

    public WilcoxonRankSum(double[] sample1, double[] sample2) {
        this(sample1, sample2, 0.0);
    }

    public WilcoxonRankSum(double[] sample1, double[] sample2, double mu, boolean isExact, boolean isCorrected) {
        super(sample1, sample2);
        int a2;
        int a3 = this.nObs();
        this.goto = sample1.length;
        this.else = sample2.length;
        this.break = isExact;
        this.final = isCorrected;
        double[] a4 = Arrays.copyOf(sample2, sample2.length);
        int a5 = 0;
        while (a5 < a4.length) {
            int n = a5++;
            a4[n] = a4[n] + mu;
        }
        double[] a22 = DoubleUtils.concat(sample1, a4);
        double[] a6 = new Rank(a22).ranks();
        int a7 = 0;
        int[] a8 = new int[this.goto + this.else];
        int a9 = 1;
        double[] a10 = a22;
        Arrays.sort(a10);
        for (a2 = 1; a2 < this.goto + this.else; ++a2) {
            a8[a9 - 1] = a10[a2 - 1] == a10[a2] ? a8[a9 - 1] + 1 : a8[a9 - 1];
            a9 = a10[a2 - 1] != a10[a2] ? a9 + 1 : a9;
        }
        for (a2 = 0; a2 < a9; ++a2) {
            a8[a2] = a8[a2] + 1;
            a7 = a7 + a8[a2] * a8[a2] * a8[a2] - a8[a2];
        }
        this.const = 0.0;
        for (a2 = 0; a2 < this.goto; ++a2) {
            this.const += a6[a2];
        }
        this.catch = new WilcoxonRankSumDistribution(this.goto, this.else);
        this.class = this.goto * this.else / 2;
        this.enum = Math.sqrt((double)(this.goto * this.else) * ((double)a3 + 1.0 - (double)a7 / (double)((this.goto + this.else) * (this.goto + this.else - 1))) / 12.0);
    }

    @Override
    public String getNullHypothesis() {
        return "the means are equal (by offset mu)";
    }

    @Override
    public double pValue() {
        double a2;
        double a3 = this.statistics();
        if (this.break) {
            a2 = this.catch.pValue(a3);
        } else if (this.final) {
            double a4 = a3 > this.class ? 0.5 : -0.5;
            double a5 = (a3 - this.class - a4) / this.enum;
            double a6 = this.void.cdf(a5);
            a2 = 2.0 * Math.min(a6, 1.0 - a6);
        } else {
            a2 = 2.0 * Math.min(this.leftOneSidedPvalue(), this.rightOneSidedPvalue());
        }
        return a2;
    }
}

