/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.regression.linear.ols;

import dev.nm.algebra.linear.matrix.doubles.linearsystem.LSProblem;
import dev.nm.algebra.linear.matrix.doubles.linearsystem.OLSSolver;
import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.algebra.linear.vector.doubles.operation.VectorFactory;
import dev.nm.misc.PrecisionUtils;
import dev.nm.stat.regression.linear.LMProblem;
import dev.nm.stat.regression.linear.LinearModel;
import dev.nm.stat.regression.linear.ols.OLSBeta;
import dev.nm.stat.regression.linear.ols.OLSResiduals;
import dev.nm.stat.regression.linear.residualanalysis.LMDiagnostics;
import dev.nm.stat.regression.linear.residualanalysis.LMInformationCriteria;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class OLSRegression
implements LinearModel {
    private final LMProblem goto;
    private final ImmutableVector enum;

    public LMInformationCriteria informationCriteria() {
        return new LMInformationCriteria(this.residuals());
    }

    public OLSRegression(LMProblem problem, double epsilon) {
        this.goto = problem;
        OLSSolver a2 = new OLSSolver(epsilon);
        this.enum = new ImmutableVector(a2.solve(new LSProblem(problem.wA(), problem.wy())));
    }

    public static double Ey(Vector beta, Vector x, boolean intercept) {
        Vector a2 = intercept ? VectorFactory.concat(x, new DenseVector(1.0)) : x;
        double a3 = beta.innerProduct(a2);
        return a3;
    }

    public OLSRegression(LMProblem problem) {
        this(problem, PrecisionUtils.autoEpsilon(problem.wA()));
    }

    @Override
    public OLSBeta beta() {
        return new OLSBeta(this.enum, (OLSResiduals)this.residuals());
    }

    @Override
    public double Ey(Vector x) {
        return OLSRegression.Ey(this.enum, x, this.goto.intercept());
    }

    public LMDiagnostics diagnostics() {
        return new LMDiagnostics(this.residuals());
    }

    @Override
    public OLSResiduals residuals() {
        OLSResiduals a2 = new OLSResiduals(this.goto, this.enum);
        return a2;
    }
}

