/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.regression.linear.glm.modelselection;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixFactory;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.number.DoubleUtils;
import dev.nm.stat.regression.linear.glm.GLMProblem;
import dev.nm.stat.regression.linear.glm.GeneralizedLinearModel;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class GLMModelSelection {
    private final int[] class;
    private final GLMProblem goto;
    private int[] enum = new int[0];

    public GeneralizedLinearModel getModel() throws ModelNotFound {
        Matrix a2 = this.subA();
        if (a2 == null) {
            throw new ModelNotFound("no factor selected");
        }
        GLMProblem a3 = new GLMProblem((Vector)this.goto.y(), a2, this.goto.intercept(), this.goto.getFamily());
        GeneralizedLinearModel a4 = new GeneralizedLinearModel(a3);
        return a4;
    }

    protected GLMModelSelection(GLMProblem problem) {
        this.goto = problem;
        this.class = new int[problem.nExogenousFactors()];
    }

    public GLMProblem problem() {
        return this.goto;
    }

    public boolean isSelected(int factorIndex) {
        return this.class[factorIndex - 1] > 0;
    }

    public int[] getFlags() {
        return Arrays.copyOf(this.class, this.class.length);
    }

    protected void dropFactor(int factorIndex) {
        this.class[this.enum[factorIndex - 1] - 1] = 0;
    }

    protected Matrix subA() {
        this.enum = DoubleUtils.select(this.class, new DoubleUtils.which(){
            {
                1 a3;
            }

            @Override
            public boolean isTrue(double x, int index) {
                return x > 0.0;
            }
        });
        Matrix a2 = this.enum.length > 0 ? MatrixFactory.columns(this.goto.A(), this.enum) : null;
        return a2;
    }

    protected void addFactor(int factorIndex) {
        this.class[factorIndex - 1] = factorIndex;
    }

    public static class ModelNotFound
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ModelNotFound(String msg) {
            super(msg);
        }
    }
}

