/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.random.rng;

import dev.nm.stat.random.rng.multivariate.RandomVectorGenerator;
import dev.nm.stat.random.rng.univariate.RandomLongGenerator;
import dev.nm.stat.random.rng.univariate.RandomNumberGenerator;
import dev.nm.stat.random.rng.univariate.normal.ConcurrentStandardNormalRNG;
import dev.nm.stat.random.rng.univariate.normal.RandomStandardNormalGenerator;
import dev.nm.stat.random.rng.univariate.normal.Zignor2005;
import dev.nm.stat.random.rng.univariate.uniform.UniformRNG;
import java.util.ArrayList;
import java.util.List;

public class RNGUtils {
    public static final RandomLongGenerator UNIFORM = new UniformRNG();
    public static final RandomLongGenerator SYNC_UNIFORM;
    public static final RandomStandardNormalGenerator CONCURRENT_RNORM;
    public static final RandomStandardNormalGenerator RNORM;
    public static final long SEED = 1234567890L;
    public static final RandomNumberGenerator SYNC_RNORM;

    public static double[] getComponent(List<double[]> list, int i2) {
        double[] a2 = new double[list.size()];
        for (int a3 = 0; a3 < list.size(); ++a3) {
            double[] a4 = list.get(a3);
            a2[a3] = a4[i2];
        }
        return a2;
    }

    public static List<double[]> nextN(RandomVectorGenerator rvg, int n) {
        ArrayList<double[]> a2 = new ArrayList<double[]>(n);
        for (int a3 = 0; a3 < n; ++a3) {
            a2.add(rvg.nextVector());
        }
        return a2;
    }

    private RNGUtils() {
        RNGUtils a2;
    }

    static {
        RNORM = new Zignor2005(UNIFORM);
        SYNC_UNIFORM = RNGUtils.synchronizedRLG(UNIFORM);
        SYNC_RNORM = RNGUtils.synchronizedRNG(RNORM);
        CONCURRENT_RNORM = new ConcurrentStandardNormalRNG(RNORM);
    }

    public static RandomLongGenerator synchronizedRLG(final RandomLongGenerator uniform) {
        return new RandomLongGenerator(){

            @Override
            public synchronized void seed(long ... seeds) {
                uniform.seed(seeds);
            }
            {
                2 a2;
            }

            @Override
            public synchronized long nextLong() {
                return uniform.nextLong();
            }

            @Override
            public synchronized double nextDouble() {
                return uniform.nextDouble();
            }
        };
    }

    public static double[] nextN(RandomNumberGenerator rng, int n) {
        double[] a2 = new double[n];
        for (int a3 = 0; a3 < n; ++a3) {
            a2[a3] = rng.nextDouble();
        }
        return a2;
    }

    public static RandomNumberGenerator synchronizedRNG(final RandomNumberGenerator rng) {
        return new RandomNumberGenerator(){

            @Override
            public synchronized void seed(long ... seeds) {
                rng.seed(seeds);
            }
            {
                1 a2;
            }

            @Override
            public synchronized double nextDouble() {
                return rng.nextDouble();
            }
        };
    }

    public static RandomVectorGenerator synchronizedRVG(final RandomVectorGenerator rng) {
        return new RandomVectorGenerator(){
            {
                3 a2;
            }

            @Override
            public synchronized void seed(long ... seeds) {
                rng.seed(seeds);
            }

            @Override
            public synchronized double[] nextVector() {
                return rng.nextVector();
            }
        };
    }
}

