/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.distribution.univariate;

import dev.nm.analysis.function.special.gamma.Gamma;
import dev.nm.analysis.function.special.gamma.GammaLanczosQuick;
import dev.nm.analysis.sequence.Summation;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.stat.distribution.univariate.ProbabilityDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WeibullDistribution
implements ProbabilityDistribution {
    private final double class;
    private static final Gamma goto = new GammaLanczosQuick();
    private final double enum;

    @Override
    public double skew() {
        double a2 = this.mean();
        double a3 = Math.sqrt(this.variance());
        double a4 = goto.evaluate(1.0 + 3.0 / this.enum) * this.class * this.class * this.class;
        a4 -= 3.0 * a2 * a3 * a3;
        a4 -= a2 * a2 * a2;
        return a4 /= a3 * a3 * a3;
    }

    @Override
    public double kurtosis() {
        double a2 = this.mean();
        double a3 = Math.sqrt(this.variance());
        double a4 = this.skew();
        double a5 = goto.evaluate(1.0 + 4.0 / this.enum) * this.class * this.class * this.class * this.class;
        a5 -= 4.0 * a4 * a3 * a3 * a3 * a2;
        a5 -= 6.0 * a2 * a2 * a3 * a3;
        a5 -= a2 * a2 * a2 * a2;
        a5 /= a3 * a3 * a3 * a3;
        return a5 -= 3.0;
    }

    @Override
    public double entropy() {
        return 0.5772156649015329 * (1.0 - 1.0 / this.enum) + Math.log(this.class / this.enum) + 1.0;
    }

    public WeibullDistribution(double lambda, double k2) {
        ArgumentAssertion.assertPositive(lambda, "lambda");
        ArgumentAssertion.assertPositive(k2, "k");
        this.class = lambda;
        this.enum = k2;
    }

    @Override
    public double moment(double x) {
        double a2 = 0.0;
        final double a3 = x;
        Summation a4 = new Summation(new Summation.Term(){

            @Override
            public double evaluate(double n) {
                double a2 = goto.evaluate(1.0 + n / WeibullDistribution.this.enum);
                int a32 = 1;
                while ((long)a32 <= Math.round(n)) {
                    a2 *= a3 * WeibullDistribution.this.class / (double)a32;
                    ++a32;
                }
                return a2;
            }
            {
                1 a32;
            }
        });
        a2 = a4.sumToInfinity(0.0, 1.0);
        return a2;
    }

    @Override
    public double variance() {
        double a2 = this.mean();
        return this.class * this.class * goto.evaluate(1.0 + 2.0 / this.enum) - a2 * a2;
    }

    @Override
    public double cdf(double x) {
        assert (x >= 0.0) : "x must be non-negative";
        return 1.0 - Math.exp(-Math.pow(x / this.class, this.enum));
    }

    @Override
    public double mean() {
        return this.class * goto.evaluate(1.0 + 1.0 / this.enum);
    }

    @Override
    public double quantile(double u) {
        return this.class * Math.pow(-Math.log(1.0 - u), 1.0 / this.enum);
    }

    @Override
    public double median() {
        return this.class * Math.pow(Math.log(2.0), 1.0 / this.enum);
    }

    @Override
    public double density(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        double a2 = this.enum / this.class;
        a2 *= Math.pow(x / this.class, this.enum - 1.0);
        return a2 *= Math.exp(-Math.pow(x / this.class, this.enum));
    }
}

