/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.distribution.univariate;

import dev.nm.analysis.function.special.beta.BetaRegularized;
import dev.nm.analysis.function.special.beta.BetaRegularizedInverse;
import dev.nm.analysis.function.special.beta.LogBeta;
import dev.nm.analysis.function.special.gamma.Digamma;
import dev.nm.analysis.function.special.gamma.LogGamma;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.ExceptionUtils;
import dev.nm.number.DoubleUtils;
import dev.nm.stat.distribution.univariate.ProbabilityDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TDistribution
implements ProbabilityDistribution {
    private final BetaRegularized catch;
    private static final LogGamma const;
    private final double void;
    private static final LogBeta class;
    private static final Digamma goto;
    private final BetaRegularizedInverse enum;

    @Override
    public double variance() {
        ExceptionUtils.throwIfNotNull(this.void >= 2.0 ? null : new UnsupportedOperationException("only for v >= 2"));
        if (this.void == 2.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.void / (this.void - 2.0);
    }

    static {
        TDistribution.class = new LogBeta();
        const = new LogGamma();
        goto = new Digamma();
    }

    @Override
    public double entropy() {
        double a2 = (this.void + 1.0) / 2.0;
        a2 *= goto.evaluate((1.0 + this.void) / 2.0) - goto.evaluate(this.void / 2.0);
        return a2 += Math.log(Math.sqrt(this.void)) + TDistribution.class.evaluate(this.void / 2.0, 0.5);
    }

    @Override
    public double median() {
        return 0.0;
    }

    public TDistribution(double v) {
        ArgumentAssertion.assertTrue(v > 0.0, "only for v > 0", new Object[0]);
        this.void = v;
        this.catch = new BetaRegularized(v / 2.0, v / 2.0);
        this.enum = new BetaRegularizedInverse(v / 2.0, v / 2.0);
    }

    @Override
    public double cdf(double x) {
        double a2 = x;
        a2 /= 2.0 * Math.sqrt(x * x + this.void);
        return this.catch.evaluate(a2 += 0.5);
    }

    @Override
    public double kurtosis() {
        ExceptionUtils.throwIfNotNull(this.void > 4.0 ? null : new UnsupportedOperationException("only for v > 4"));
        return 6.0 / (this.void - 4.0);
    }

    @Override
    public double skew() {
        ExceptionUtils.throwIfNotNull(this.void > 3.0 ? null : new UnsupportedOperationException("only for v > 3"));
        return 0.0;
    }

    @Override
    public double quantile(double u) {
        double a2 = this.enum.evaluate(u);
        double a3 = 0.25 / (a2 - 0.5) / (a2 - 0.5) / this.void - 1.0 / this.void;
        a3 = 1.0 / a3;
        a3 = Math.sqrt(a3);
        a3 = a2 - 0.5 > 0.0 ? a3 : -a3;
        return a3;
    }

    @Override
    public double density(double x) {
        if (DoubleUtils.isZero(x, 0.0)) {
            return 0.0;
        }
        double a2 = const.evaluate((this.void + 1.0) / 2.0);
        a2 -= Math.log(Math.sqrt(this.void * Math.PI)) + const.evaluate(this.void / 2.0);
        a2 += -(this.void + 1.0) / 2.0 * Math.log(1.0 + x * x / this.void);
        a2 = Math.exp(a2);
        return a2;
    }

    @Override
    public double mean() {
        ExceptionUtils.throwIfNotNull(this.void > 1.0 ? null : new UnsupportedOperationException("only for v > 1"));
        return 0.0;
    }

    @Override
    public double moment(double x) {
        throw new UnsupportedOperationException("not defined.");
    }
}

