/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.descriptive.correlation;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.algebra.linear.vector.doubles.operation.VectorFactory;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.Constants;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CorrelationMatrix
extends DenseMatrix {
    private final Vector enum;

    public double var(int i2) {
        return this.enum.get(i2);
    }

    private static DenseMatrix do(Matrix a2) {
        ArgumentAssertion.assertTrue(MatrixPropertyUtils.isSymmetric(a2, 0.0), "the covariance matrix must be symmetric", new Object[0]);
        int a3 = a2.nRows();
        int a4 = a2.nCols();
        Vector a5 = VectorFactory.diagonal(a2);
        DenseMatrix a6 = new DenseMatrix(a3, a4);
        for (int a7 = 1; a7 <= a2.nCols(); ++a7) {
            for (int a8 = a7; a8 <= a2.nRows(); ++a8) {
                double a9 = 0.0;
                if (a5.get(a7) > Constants.EPSILON && a5.get(a8) > Constants.EPSILON) {
                    a9 = a2.get(a7, a8) / Math.sqrt(a5.get(a7)) / Math.sqrt(a5.get(a8));
                }
                a6.set(a7, a8, a9);
                a6.set(a8, a7, a9);
            }
        }
        return a6;
    }

    public double stdev(int i2) {
        double a2 = this.enum.get(i2);
        double a3 = Math.sqrt(a2);
        return a3;
    }

    public Vector var() {
        return new ImmutableVector(this.enum);
    }

    public Vector stdev() {
        int a2 = this.enum.size();
        double[] a3 = new double[a2];
        for (int a4 = 1; a4 <= a2; ++a4) {
            a3[a4 - 1] = this.stdev(a4);
        }
        return new DenseVector(a3);
    }

    public CorrelationMatrix(Matrix cov) {
        super(CorrelationMatrix.do(cov), false);
        this.enum = VectorFactory.diagonal(cov);
    }
}

