/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.covariance.nlshrink;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.EigenDecomposition;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import dev.nm.stat.covariance.LedoitWolf2004;
import dev.nm.stat.covariance.nlshrink.NonlinearShrinkageEstimator;
import dev.nm.stat.covariance.nlshrink.TauEstimator;
import dev.nm.stat.descriptive.covariance.SampleCovariance;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LedoitWolf2016 {
    private final boolean enum;

    static {
        Package.validate("NMDEV_LEDOITWOLF2016");
    }

    public LedoitWolf2016() {
        this(true);
    }

    public LedoitWolf2016(boolean unbiased) {
        this.enum = unbiased;
    }

    public Result estimate(Matrix Y) {
        return new Result(Y, this.enum);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Result {
        private final Matrix catch;
        private final Vector const;
        private final EigenDecomposition void;
        private final Vector class;
        private final Vector goto;
        private final Vector enum;

        public Matrix getShrunkCovarianceMatrix() {
            int a2 = this.enum.size();
            int[] a3 = DoubleUtils.order(this.enum.toArray());
            double[] a4 = new double[a2];
            for (int a5 = 0; a5 < a2; ++a5) {
                a4[a5] = this.const.get(a3[a5]);
            }
            DiagonalMatrix a6 = new DiagonalMatrix(a4);
            Matrix a7 = this.void.Q();
            Matrix a8 = this.void.Qt();
            Matrix a9 = a7.multiply(a6).multiply(a8);
            return a9;
        }

        private Result(Matrix a2, boolean a3) {
            Result a4;
            int a5 = a2.nCols();
            int a6 = a2.nRows();
            a4.catch = new SampleCovariance(a2, a3);
            a4.void = new EigenDecomposition(a4.catch);
            a4.enum = a4.void.D().getDiagonal();
            for (int a7 = 1; a7 <= a5; ++a7) {
                if (!(a4.enum.get(a7) < 0.0)) continue;
                a4.enum.set(a7, 0.0);
            }
            Matrix a8 = new LedoitWolf2004().compute(a2).getCovarianceMatrix();
            EigenDecomposition a9 = new EigenDecomposition(a8);
            a4.goto = a9.D().getDiagonal();
            a4.class = new TauEstimator(a5, a6, a4.enum).estimatedPopulationEigenvalues(a4.goto);
            a4.const = new NonlinearShrinkageEstimator(a4.class, a6 - 1).nonlinearShrunkEigenvalues();
        }

        public Vector lambda() {
            return new ImmutableVector(this.enum);
        }

        public Vector tau() {
            return new ImmutableVector(this.class);
        }

        public ImmutableMatrix S() {
            return new ImmutableMatrix(this.catch);
        }

        public Vector linshrink_tau() {
            return new ImmutableVector(this.goto);
        }

        public Vector nlshrink_tau() {
            return new ImmutableVector(this.const);
        }
    }
}

