/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.number.doublearray;

import dev.nm.misc.license.Package;

public class DoubleArrayMath {
    public static double[] exp(double[] doubles) {
        double[] a2 = new double[doubles.length];
        for (int a3 = 0; a3 < doubles.length; ++a3) {
            a2[a3] = Math.exp(doubles[a3]);
        }
        return a2;
    }

    public static double[] expm1(double[] doubles) {
        double[] a2 = new double[doubles.length];
        for (int a3 = 0; a3 < doubles.length; ++a3) {
            a2[a3] = Math.expm1(doubles[a3]);
        }
        return a2;
    }

    public static double[] signum(double[] doubles) {
        double[] a2 = new double[doubles.length];
        for (int a3 = 0; a3 < doubles.length; ++a3) {
            a2[a3] = Math.signum(doubles[a3]);
        }
        return a2;
    }

    public static double min(double ... doubles) {
        double a2 = Double.POSITIVE_INFINITY;
        for (double a3 : doubles) {
            if (!(a3 < a2)) continue;
            a2 = a3;
        }
        return a2;
    }

    public static double sum2(double ... doubles) {
        double a2 = 0.0;
        for (double a3 : doubles) {
            a2 += a3 * a3;
        }
        return a2;
    }

    public static double sum(double ... doubles) {
        double a2 = 0.0;
        for (double a3 : doubles) {
            a2 += a3;
        }
        return a2;
    }

    public static double[] abs(double[] doubles) {
        double[] a2 = new double[doubles.length];
        for (int a3 = 0; a3 < doubles.length; ++a3) {
            a2[a3] = Math.abs(doubles[a3]);
        }
        return a2;
    }

    private DoubleArrayMath() {
        DoubleArrayMath a2;
    }

    public static double[] reciprocal(double[] doubles) {
        double[] a2 = new double[doubles.length];
        for (int a3 = 0; a3 < doubles.length; ++a3) {
            a2[a3] = 1.0 / doubles[a3];
        }
        return a2;
    }

    public static double[] pow(double[] doubles, double exponent) {
        double[] a2 = new double[doubles.length];
        for (int a3 = 0; a3 < doubles.length; ++a3) {
            a2[a3] = Math.pow(doubles[a3], exponent);
        }
        return a2;
    }

    public static double max(double ... doubles) {
        double a2 = Double.NEGATIVE_INFINITY;
        for (double a3 : doubles) {
            if (!(a3 > a2)) continue;
            a2 = a3;
        }
        return a2;
    }

    public static int max(int ... integers) {
        int a2 = Integer.MIN_VALUE;
        for (int a3 : integers) {
            if (a3 <= a2) continue;
            a2 = a3;
        }
        return a2;
    }

    public static double[] sqrt(double[] doubles) {
        double[] a2 = new double[doubles.length];
        for (int a3 = 0; a3 < doubles.length; ++a3) {
            a2[a3] = Math.sqrt(doubles[a3]);
        }
        return a2;
    }

    public static double[] log(double[] doubles) {
        double[] a2 = new double[doubles.length];
        for (int a3 = 0; a3 < doubles.length; ++a3) {
            a2[a3] = Math.log(doubles[a3]);
        }
        return a2;
    }

    static {
        Package.validate("NMDEV_BASIC");
    }

    public static int sum(int ... integers) {
        int a2 = 0;
        for (int a3 : integers) {
            a2 += a3;
        }
        return a2;
    }

    public static double[] add(double[] doubles, double value) {
        double[] a2 = new double[doubles.length];
        for (int a3 = 0; a3 < doubles.length; ++a3) {
            a2[a3] = doubles[a3] + value;
        }
        return a2;
    }

    public static double[] scale(double[] doubles, double multiplier) {
        double[] a2 = new double[doubles.length];
        for (int a3 = 0; a3 < doubles.length; ++a3) {
            a2[a3] = doubles[a3] * multiplier;
        }
        return a2;
    }
}

