/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.misc.datastructure.time;

import dev.nm.misc.ArgumentAssertion;
import java.time.LocalDateTime;
import java.time.Period;
import java.util.Objects;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class LocalDateTimeInterval {
    private final LocalDateTime goto;
    private final LocalDateTime enum;

    public LocalDateTime start() {
        return this.enum;
    }

    public boolean contains(LocalDateTime t) {
        return !t.isBefore(this.enum) && t.isBefore(this.goto);
    }

    public int hashCode() {
        int a2 = 5;
        a2 = 67 * a2 + Objects.hashCode(this.enum);
        a2 = 67 * a2 + Objects.hashCode(this.goto);
        return a2;
    }

    public String toString() {
        return String.format("[%s,%s)", this.start(), this.end());
    }

    public static LocalDateTimeInterval of(Period period, LocalDateTime end) {
        return new LocalDateTimeInterval(end.minus(period), end);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocalDateTimeInterval a2 = (LocalDateTimeInterval)obj;
        if (!Objects.equals(this.enum, a2.enum)) {
            return false;
        }
        return Objects.equals(this.goto, a2.goto);
    }

    private LocalDateTimeInterval(LocalDateTime a2, LocalDateTime a3) {
        LocalDateTimeInterval a4;
        ArgumentAssertion.assertTrue(!a3.isBefore(a2), "start time (%s) cannot be after end time (%s)", a2, a3);
        a4.enum = a2;
        a4.goto = a3;
    }

    public boolean overlaps(LocalDateTimeInterval other) {
        return this.start().isBefore(other.end()) && other.start().isBefore(this.end());
    }

    public static LocalDateTimeInterval of(LocalDateTime start, Period period) {
        return new LocalDateTimeInterval(start, start.plus(period));
    }

    public static LocalDateTimeInterval of(LocalDateTime start, LocalDateTime end) {
        return new LocalDateTimeInterval(start, end);
    }

    public LocalDateTime end() {
        return this.goto;
    }

    public boolean contains(LocalDateTimeInterval other) {
        return !this.start().isAfter(other.start()) && other.start().isBefore(this.end()) && !other.end().isAfter(this.end());
    }
}

