/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.sequence;

import dev.nm.misc.ExceptionUtils;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Summation {
    private final Term goto;
    private final double enum;

    public Summation(Term term) {
        this.goto = term;
        this.enum = 0.0;
    }

    public double sumToInfinity(int from) {
        return this.sumToInfinity(from, 1.0);
    }

    public double sum(int from, int to) {
        return this.sum(from, to, 1);
    }

    static {
        Package.validate("NMDEV_BASIC");
    }

    public double sum(double[] indices) {
        double a2 = 0.0;
        for (double a3 : indices) {
            double a4 = this.goto.evaluate(a3);
            a2 += a4;
        }
        return a2;
    }

    public Summation(Term term, double threshold) {
        this.goto = term;
        this.enum = threshold;
    }

    public double sumToInfinity(double from, double inc) {
        double a2;
        ExceptionUtils.throwIfNotNull(this.enum > 0.0 ? null : new RuntimeException("the convergence threshold is 0; summing will not stop"));
        double a3 = 0.0;
        double a4 = from;
        while (!(Math.abs(a2 = this.goto.evaluate(a4)) < this.enum)) {
            a3 += a2;
            a4 += inc;
        }
        return a3;
    }

    public double sum(double from, double to, double inc) {
        double[] a2 = DoubleUtils.seq(from, to, inc);
        return this.sum(a2);
    }

    public double sum(int from, int to, int inc) {
        return this.sum((double)from, (double)to, (double)inc);
    }

    public static interface Term {
        public double evaluate(double var1);
    }
}

