/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.differentialequation.ode.ivp.solver.rungekutta;

import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.analysis.differentialequation.ode.ivp.problem.ODE1stOrder;
import dev.nm.analysis.differentialequation.ode.ivp.solver.ODESolution;
import dev.nm.analysis.differentialequation.ode.ivp.solver.ODESolver;
import dev.nm.analysis.differentialequation.ode.ivp.solver.rungekutta.RungeKuttaIntegrator;
import dev.nm.analysis.differentialequation.ode.ivp.solver.rungekutta.RungeKuttaStepper;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RungeKutta
implements ODESolver {
    private final Step goto;
    private final RungeKuttaStepper enum;

    static {
        Package.validate("NMDEV_OPDE");
    }

    public RungeKutta(RungeKuttaStepper stepper, final double h2) {
        this.enum = stepper;
        this.goto = new Step(){
            {
                1 a3;
            }

            @Override
            public double size(double x0, double x1) {
                return h2;
            }
        };
    }

    public RungeKutta(RungeKuttaStepper stepper, final int N) {
        ArgumentAssertion.assertNotLessThan(N, 2, "N");
        this.enum = stepper;
        this.goto = new Step(){

            @Override
            public double size(double x0, double x1) {
                return (x1 - x0) / (double)(N - 1);
            }
            {
                2 a3;
            }
        };
    }

    @Override
    public ODESolution solve(ODE1stOrder ode) {
        double[] a2 = DoubleUtils.seq(ode.x0(), ode.x1(), this.goto.size(ode.x0(), ode.x1()));
        a2[a2.length - 1] = ode.x1();
        RungeKuttaIntegrator a3 = new RungeKuttaIntegrator(this.enum);
        Vector[] a4 = a3.integrate(ode, a2);
        return new ODESolution(a2, a4);
    }

    private static interface Step {
        public double size(double var1, double var3);
    }
}

