/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.curvefit.interpolation.bivariate;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.analysis.curvefit.interpolation.bivariate.BivariateGrid;
import dev.nm.analysis.curvefit.interpolation.bivariate.BivariateGridInterpolation;
import dev.nm.analysis.curvefit.interpolation.bivariate.BivariateInterpolationUtils;
import dev.nm.analysis.curvefit.interpolation.bivariate.PartialDerivativesByCenteredDifferencing;
import dev.nm.analysis.function.rn2r1.AbstractRealScalarFunction;
import dev.nm.analysis.function.rn2r1.RealScalarFunction;
import dev.nm.misc.license.Package;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BicubicInterpolation
implements BivariateGridInterpolation {
    private static final Matrix goto;
    private final PartialDerivatives enum;

    @Override
    public RealScalarFunction interpolate(final BivariateGrid grid) {
        return new AbstractRealScalarFunction(2){

            @Override
            public Double evaluate(Vector d2) {
                double a2 = d2.get(1);
                double a3 = d2.get(2);
                int[] a4 = BivariateInterpolationUtils.getSurroundingIndices(grid, a2, a3);
                int a5 = a4[0];
                int a6 = a4[1];
                int a7 = a4[2];
                int a8 = a4[3];
                Vector a9 = BicubicInterpolation.this.do(grid, a5, a6, a7, a8);
                Vector a10 = goto.multiply(a9);
                double[][] a11 = BicubicInterpolation.this.do(a10);
                double a12 = (a2 - grid.x(a5)) / (grid.x(a6) - grid.x(a5));
                double a13 = (a3 - grid.y(a7)) / (grid.y(a8) - grid.y(a7));
                double a14 = 0.0;
                for (int a15 = 0; a15 < 4; ++a15) {
                    for (int a16 = 0; a16 < 4; ++a16) {
                        a14 += a11[a15][a16] * Math.pow(a12, a15) * Math.pow(a13, a16);
                    }
                }
                return a14;
            }
            {
                1 a4;
                super(a3);
            }
        };
    }

    public BicubicInterpolation() {
        this(new PartialDerivativesByCenteredDifferencing());
    }

    private double[][] do(Vector a2) {
        double[][] a3 = new double[4][4];
        for (int a4 = 0; a4 < 4; ++a4) {
            for (int a5 = 0; a5 < 4; ++a5) {
                a3[a4][a5] = a2.get(1 + a4 + 4 * a5);
            }
        }
        return a3;
    }

    public BicubicInterpolation(PartialDerivatives derivatives) {
        this.enum = derivatives;
    }

    static {
        Package.validate("NMDEV_BASIC");
        goto = new DenseMatrix(new double[][]{{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {-3.0, 3.0, 0.0, 0.0, -2.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {2.0, -2.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -3.0, 3.0, 0.0, 0.0, -2.0, -1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, -2.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0}, {-3.0, 0.0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, -3.0, 0.0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0, 0.0, -1.0, 0.0}, {9.0, -9.0, -9.0, 9.0, 6.0, 3.0, -6.0, -3.0, 6.0, -6.0, 3.0, -3.0, 4.0, 2.0, 2.0, 1.0}, {-6.0, 6.0, 6.0, -6.0, -3.0, -3.0, 3.0, 3.0, -4.0, 4.0, -2.0, 2.0, -2.0, -2.0, -1.0, -1.0}, {2.0, 0.0, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 2.0, 0.0, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0}, {-6.0, 6.0, 6.0, -6.0, -4.0, -2.0, 4.0, 2.0, -3.0, 3.0, -3.0, 3.0, -2.0, -1.0, -2.0, -1.0}, {4.0, -4.0, -4.0, 4.0, 2.0, 2.0, -2.0, -2.0, 2.0, -2.0, 2.0, -2.0, 1.0, 1.0, 1.0, 1.0}});
    }

    private Vector do(BivariateGrid a2, int a3, int a4, int a5, int a6) {
        BicubicInterpolation a7;
        DenseVector a8 = new DenseVector(16);
        double a9 = a2.x(a4) - a2.x(a3);
        double a10 = a2.y(a6) - a2.y(a5);
        a8.set(1, a2.z(a3, a5));
        a8.set(2, a2.z(a4, a5));
        a8.set(3, a2.z(a3, a6));
        a8.set(4, a2.z(a4, a6));
        a8.set(5, a7.enum.dx(a2, a3, a5) * a9);
        a8.set(6, a7.enum.dx(a2, a4, a5) * a9);
        a8.set(7, a7.enum.dx(a2, a3, a6) * a9);
        a8.set(8, a7.enum.dx(a2, a4, a6) * a9);
        a8.set(9, a7.enum.dy(a2, a3, a5) * a10);
        a8.set(10, a7.enum.dy(a2, a4, a5) * a10);
        a8.set(11, a7.enum.dy(a2, a3, a6) * a10);
        a8.set(12, a7.enum.dy(a2, a4, a6) * a10);
        a8.set(13, a7.enum.dxdy(a2, a3, a5) * a9 * a10);
        a8.set(14, a7.enum.dxdy(a2, a4, a5) * a9 * a10);
        a8.set(15, a7.enum.dxdy(a2, a3, a6) * a9 * a10);
        a8.set(16, a7.enum.dxdy(a2, a4, a6) * a9 * a10);
        return a8;
    }

    public static interface PartialDerivatives {
        public double dxdy(BivariateGrid var1, int var2, int var3);

        public double dx(BivariateGrid var1, int var2, int var3);

        public double dy(BivariateGrid var1, int var2, int var3);
    }
}

