/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.vector.doubles.operation;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseVector;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixUtils;
import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.analysis.function.rn2r1.RealScalarFunction;
import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import dev.nm.analysis.function.rn2rm.RealVectorFunction;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.number.DoubleUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.DoubleUnaryOperator;

public class VectorFactory {
    public static SparseVector subVector(SparseVector vector, int from, int to) {
        ArgumentAssertion.assertTrue(to >= from, "The ending index must not be smaller than the beginning index!", new Object[0]);
        SparseVector a2 = new SparseVector(to - from + 1);
        for (SparseVector.Entry a3 : vector) {
            if (from > a3.index() || a3.index() > to) continue;
            a2.set(a3.index() - from + 1, a3.value());
        }
        return a2;
    }

    public static Vector subVector(Vector vector, List<Integer> indices) {
        return VectorFactory.subVector(vector, DoubleUtils.collection2IntArray(indices));
    }

    public static Vector foreachRow(Matrix matrix, RealScalarFunction f2) {
        Vector[] a2 = new Vector[matrix.nRows()];
        if (matrix instanceof SparseMatrix) {
            for (int a3 = 0; a3 < matrix.nRows(); ++a3) {
                a2[a3] = (SparseVector)matrix.getRow(a3 + 1);
            }
        } else {
            a2 = MatrixUtils.toRows(matrix);
        }
        return VectorFactory.foreachVector(a2, f2);
    }

    public static Vector subVector(Vector vector, int from, int to) {
        ArgumentAssertion.assertTrue(to >= from, "The ending index must not be smaller than the beginning index!", new Object[0]);
        if (vector instanceof SparseVector) {
            return VectorFactory.subVector((SparseVector)vector, from, to);
        }
        double[] a2 = Arrays.copyOfRange(vector.toArray(), from - 1, to);
        return new DenseVector(a2);
    }

    private VectorFactory() {
        VectorFactory a2;
    }

    public static Vector replaceInPlace(Vector original, int from, Vector replacement) {
        ArgumentAssertion.assertTrue(from >= 1 && from <= original.size(), "'from' must be in range [1, %d]", original.size());
        ArgumentAssertion.assertTrue(from + replacement.size() - 1 <= original.size(), "replacement is too large (size=%d)", replacement.size());
        for (int a2 = 1; a2 <= replacement.size(); ++a2) {
            original.set(from + a2 - 1, replacement.get(a2));
        }
        return original;
    }

    public static Vector concat(Vector ... vectors) {
        if (vectors == null || vectors.length == 0 || Arrays.stream(vectors).allMatch(Objects::isNull)) {
            return null;
        }
        if (MatrixPropertyUtils.areAllSparse(vectors)) {
            return VectorFactory.concat((SparseVector[])Arrays.copyOf(vectors, vectors.length, SparseVector[].class));
        }
        int a2 = 0;
        for (int a3 = 0; a3 < vectors.length; ++a3) {
            a2 += vectors[a3] != null ? vectors[a3].size() : 0;
        }
        double[] a4 = new double[a2];
        int a5 = 0;
        for (int a6 = 0; a6 < vectors.length; ++a6) {
            if (vectors[a6] == null) continue;
            for (int a7 = 1; a7 <= vectors[a6].size(); ++a7) {
                a4[a5] = vectors[a6].get(a7);
                ++a5;
            }
        }
        return new DenseVector(a4);
    }

    public static Vector foreachVector(Vector[] vectors, RealScalarFunction f2) {
        int a2 = vectors.length;
        double[] a3 = new double[a2];
        for (int a4 = 0; a4 < a2; ++a4) {
            a3[a4] = (Double)f2.evaluate(vectors[a4]);
        }
        if (MatrixPropertyUtils.areAllSparse(vectors)) {
            return new SparseVector(a2, DoubleUtils.seq(1, a2), a3);
        }
        return new DenseVector(a3);
    }

    public static Vector foreach(Vector vector, UnivariateRealFunction f2) {
        if (vector instanceof SparseVector) {
            return VectorFactory.foreach((SparseVector)vector, f2);
        }
        double[] a2 = vector.toArray();
        return new DenseVector(DoubleUtils.foreach(a2, f2));
    }

    public static List<Vector> getOffsetVectors(Vector v0, Vector dv, int a2, int b2) {
        ArgumentAssertion.assertTrue(dv.size() == v0.size(), "the dimensions of the initial vector (%d) and the delta (%d) must equal", dv.size(), v0.size());
        ArgumentAssertion.assertTrue(b2 >= a2, "b (%d) must be greater than or equal to a (%d)", b2, a2);
        ArrayList<Vector> a3 = new ArrayList<Vector>(b2 - a2 + 1);
        for (int a4 = a2; a4 <= b2; ++a4) {
            a3.add(v0.add(dv.scaled(a4)));
        }
        return a3;
    }

    public static Vector foreach(Vector vector, final DoubleUnaryOperator f2) {
        return VectorFactory.foreach(vector, (UnivariateRealFunction)new AbstractUnivariateRealFunction(){

            @Override
            public double evaluate(double x) {
                return f2.applyAsDouble(x);
            }
            {
                1 a2;
            }
        });
    }

    public static SparseVector subDiagonal(SparseMatrix A2) {
        int a2 = Math.min(A2.nRows(), A2.nCols()) - 1;
        ArgumentAssertion.assertTrue(a2 > 0, "1x1 matrix has no super-diagonal", new Object[0]);
        ArrayList<SparseVector.Entry> a3 = new ArrayList<SparseVector.Entry>();
        if (a2 < A2.nNonZeros()) {
            for (int a4 = 1; a4 <= a2; ++a4) {
                double a5 = A2.get(a4 + 1, a4);
                if (a5 == 0.0) continue;
                a3.add(new SparseVector.Entry(a4, a5));
            }
        } else {
            for (SparseMatrix.Entry a6 : A2.getEntryList()) {
                if (a6.coordinates.i - 1 != a6.coordinates.j) continue;
                a3.add(new SparseVector.Entry(a6.coordinates.i, a6.value));
            }
        }
        return new SparseVector(a2, a3);
    }

    public static Vector diagonal(Matrix A2) {
        if (A2 instanceof SparseMatrix) {
            return VectorFactory.diagonal((SparseMatrix)A2);
        }
        int a2 = Math.min(A2.nRows(), A2.nCols());
        double[] a3 = new double[a2];
        for (int a4 = 1; a4 <= a2; ++a4) {
            a3[a4 - 1] = A2.get(a4, a4);
        }
        return new DenseVector(a3);
    }

    public static Vector getCoordinate(Collection<Vector> vectors, int i2) {
        return VectorFactory.getCoordinate(vectors.toArray(new Vector[0]), i2);
    }

    public static SparseVector superDiagonal(SparseMatrix A2) {
        int a2 = Math.min(A2.nRows(), A2.nCols()) - 1;
        ArgumentAssertion.assertTrue(a2 > 0, "1x1 matrix has no super-diagonal", new Object[0]);
        ArrayList<SparseVector.Entry> a3 = new ArrayList<SparseVector.Entry>();
        if (a2 < A2.nNonZeros()) {
            for (int a4 = 1; a4 <= a2; ++a4) {
                double a5 = A2.get(a4, a4 + 1);
                if (a5 == 0.0) continue;
                a3.add(new SparseVector.Entry(a4, a5));
            }
        } else {
            for (SparseMatrix.Entry a6 : A2.getEntryList()) {
                if (a6.coordinates.i != a6.coordinates.j - 1) continue;
                a3.add(new SparseVector.Entry(a6.coordinates.i, a6.value));
            }
        }
        return new SparseVector(a2, a3);
    }

    public static Vector superDiagonal(Matrix A2) {
        if (A2 instanceof SparseMatrix) {
            return VectorFactory.superDiagonal((SparseMatrix)A2);
        }
        int a2 = Math.min(A2.nRows(), A2.nCols()) - 1;
        ArgumentAssertion.assertTrue(a2 > 0, "1x1 matrix has no super-diagonal", new Object[0]);
        double[] a3 = new double[a2];
        for (int a4 = 1; a4 <= a2; ++a4) {
            a3[a4 - 1] = A2.get(a4, a4 + 1);
        }
        return new DenseVector(a3);
    }

    public static Vector subVector(Vector vector, int[] indices) {
        int a2 = indices == null ? 0 : indices.length;
        Vector a3 = vector instanceof SparseVector ? new SparseVector(a2) : new DenseVector(a2);
        for (int a4 = 0; a4 < a2; ++a4) {
            a3.set(a4 + 1, vector.get(indices[a4]));
        }
        return a3;
    }

    public static SparseVector concat(SparseVector ... vectors) {
        if (vectors == null || vectors.length == 0 || Arrays.stream(vectors).allMatch(Objects::isNull)) {
            return null;
        }
        int a2 = 0;
        for (SparseVector a3 : vectors) {
            if (a3 == null) continue;
            a2 += a3.size();
        }
        SparseVector a4 = new SparseVector(a2);
        int a5 = 0;
        for (SparseVector a6 : vectors) {
            if (a6 == null) continue;
            for (SparseVector.Entry a7 : a6) {
                a4.set(a5 + a7.index(), a7.value());
            }
            a5 += a6.size();
        }
        return a4;
    }

    public static SparseVector foreach(SparseVector vector, UnivariateRealFunction f2) {
        double a2 = f2.evaluate(0.0);
        if (a2 == 0.0) {
            Object a3 = vector.ZERO();
            for (SparseVector.Entry a4 : vector) {
                ((SparseVector)a3).set(a4.index(), f2.evaluate(a4.value()));
            }
            return a3;
        }
        int a5 = vector.size();
        double[] a6 = new double[a5];
        Arrays.fill(a6, a2);
        for (SparseVector.Entry a7 : vector) {
            a6[a7.index() - 1] = f2.evaluate(a7.value());
        }
        return new SparseVector(a5, DoubleUtils.seq(1, a5), a6);
    }

    public static Vector foreachColumn(Matrix matrix, RealScalarFunction f2) {
        Vector[] a2 = new Vector[matrix.nCols()];
        if (matrix instanceof SparseMatrix) {
            for (int a3 = 0; a3 < matrix.nCols(); ++a3) {
                a2[a3] = (SparseVector)matrix.getColumn(a3 + 1);
            }
        } else {
            a2 = MatrixUtils.toColumns(matrix);
        }
        return VectorFactory.foreachVector(a2, f2);
    }

    public static Vector subDiagonal(Matrix A2) {
        if (A2 instanceof SparseMatrix) {
            return VectorFactory.subDiagonal((SparseMatrix)A2);
        }
        int a2 = Math.min(A2.nRows(), A2.nCols()) - 1;
        ArgumentAssertion.assertTrue(a2 > 0, "1x1 matrix has no sub-diagonal", new Object[0]);
        double[] a3 = new double[a2];
        for (int a4 = 1; a4 <= a2; ++a4) {
            a3[a4 - 1] = A2.get(a4 + 1, a4);
        }
        return new DenseVector(a3);
    }

    public static Vector foreachVector(Collection<Vector> vectors, RealScalarFunction f2) {
        return VectorFactory.foreachVector(vectors.toArray(new Vector[0]), f2);
    }

    public static Vector[] get0s(int dimension, int n) {
        Vector[] a2 = new Vector[n];
        for (int a3 = 0; a3 < n; ++a3) {
            a2[a3] = new DenseVector(dimension);
        }
        return a2;
    }

    public static Vector[] cumsum(Vector[] arr) {
        ArgumentAssertion.assertPositive(arr.length, "arr length");
        Vector[] a2 = new Vector[arr.length];
        a2[0] = new ImmutableVector(arr[0]);
        for (int a3 = 1; a3 < arr.length; ++a3) {
            a2[a3] = a2[a3 - 1].add(arr[a3]);
        }
        return a2;
    }

    public static Vector concat(Collection<Vector> vectors) {
        return VectorFactory.concat(vectors.toArray(new Vector[0]));
    }

    public static Vector getCoordinate(Vector[] vectors, int i2) {
        int a2 = vectors.length;
        double[] a3 = new double[a2];
        for (int a4 = 0; a4 < a2; ++a4) {
            a3[a4] = vectors[a4].get(i2);
        }
        if (MatrixPropertyUtils.areAllSparse(vectors)) {
            return new SparseVector(a2, DoubleUtils.seq(1, a2), a3);
        }
        return new DenseVector(a3);
    }

    public static Vector[] foreachVector(Vector[] vectors, RealVectorFunction f2) {
        Vector[] a2 = new Vector[vectors.length];
        for (int a3 = 0; a3 < vectors.length; ++a3) {
            a2[a3] = (Vector)f2.evaluate(vectors[a3]);
        }
        return a2;
    }

    public static Vector[] foreachVector(Collection<Vector> vectors, RealVectorFunction f2) {
        return VectorFactory.foreachVector(vectors.toArray(new Vector[0]), f2);
    }

    public static SparseVector diagonal(SparseMatrix A2) {
        int a2 = Math.min(A2.nRows(), A2.nCols());
        ArrayList<SparseVector.Entry> a3 = new ArrayList<SparseVector.Entry>();
        if (a2 < A2.nNonZeros()) {
            for (int a4 = 1; a4 <= a2; ++a4) {
                double a5 = A2.get(a4, a4);
                if (a5 == 0.0) continue;
                a3.add(new SparseVector.Entry(a4, a5));
            }
        } else {
            for (SparseMatrix.Entry a6 : A2.getEntryList()) {
                if (a6.coordinates.i != a6.coordinates.j) continue;
                a3.add(new SparseVector.Entry(a6.coordinates.i, a6.value));
            }
        }
        return new SparseVector(a2, a3);
    }
}

