/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.operation;

import dev.nm.algebra.linear.matrix.MatrixAccessException;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixAccess;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.mathoperation.AutoParallelMatrixMathOperation;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.mathoperation.MatrixMathOperation;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.datastructure.DimensionCheck;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FastKroneckerProduct
implements Matrix {
    private final Matrix class;
    private final Matrix goto;
    private static final MatrixMathOperation enum = new AutoParallelMatrixMathOperation();

    @Override
    public DenseMatrix ONE() {
        return new DenseMatrix(this.nRows(), this.nCols()).ONE();
    }

    @Override
    public Matrix minus(Matrix that) {
        return enum.minus(this, that);
    }

    @Override
    public DenseMatrix ZERO() {
        return new DenseMatrix(this.nRows(), this.nCols()).ZERO();
    }

    @Override
    public DenseVector getRow(int i2) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, i2);
        double[] a2 = new double[this.nCols()];
        for (int a3 = 0; a3 < a2.length; ++a3) {
            a2[a3] = this.get(i2, a3 + 1);
        }
        return new DenseVector(a2);
    }

    @Override
    public Matrix add(Matrix that) {
        return enum.add(this, that);
    }

    @Override
    public Vector multiply(Vector v) {
        return enum.multiply((MatrixAccess)this, v);
    }

    @Override
    public Matrix opposite() {
        return this.scaled(-1.0);
    }

    @Override
    public Matrix scaled(double scalar) {
        return enum.scaled(this, scalar);
    }

    @Override
    public Matrix t() {
        return enum.transpose(this);
    }

    @Override
    public void set(int i2, int j2, double value) throws MatrixAccessException {
        throw new MatrixAccessException("this matrix is immutable");
    }

    @Override
    public int nRows() {
        return this.goto.nRows() * this.class.nRows();
    }

    public FastKroneckerProduct(Matrix A2, Matrix B2) {
        this.goto = A2.deepCopy();
        this.class = B2.deepCopy();
    }

    @Override
    public Matrix multiply(Matrix that) {
        return enum.multiply((MatrixAccess)this, that);
    }

    @Override
    public double get(int i2, int j2) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, i2);
        DimensionCheck.throwIfInvalidColumn(this, j2);
        int a2 = i2 - 1;
        int a3 = j2 - 1;
        int a4 = this.class.nRows();
        int a5 = this.class.nCols();
        return this.goto.get(a2 / a4 + 1, a3 / a5 + 1) * this.class.get(a2 % a4 + 1, a3 % a5 + 1);
    }

    @Override
    public FastKroneckerProduct deepCopy() {
        return this;
    }

    @Override
    public DenseVector getColumn(int j2) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidColumn(this, j2);
        double[] a2 = new double[this.nRows()];
        for (int a3 = 0; a3 < a2.length; ++a3) {
            a2[a3] = this.get(a3 + 1, j2);
        }
        return new DenseVector(a2);
    }

    @Override
    public int nCols() {
        return this.goto.nCols() * this.class.nCols();
    }
}

