/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.factorization.eigen;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.operation.Inverse;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixMeasure;
import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.Constants;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class InverseIteration {
    private final ImmutableMatrix class;
    private final StoppingCriterion goto;
    private final ImmutableMatrix enum;

    public Vector getEigenVector(Vector v0, int maxIterations) {
        Vector a2 = v0;
        for (int a3 = 0; a3 < maxIterations; ++a3) {
            Vector a4 = this.enum.multiply(a2);
            a2 = a4 = a4.scaled(1.0 / a4.norm());
            if (this.goto.toStop(a2)) break;
        }
        return new ImmutableVector(a2);
    }

    public Vector getEigenVector() {
        return this.getEigenVector(new DenseVector(this.class.nRows(), 1.0), 10);
    }

    public InverseIteration(final Matrix A2, final double lambda) {
        this(A2, lambda, new StoppingCriterion(){
            private final Matrix goto;
            private final double enum;
            {
                1 a2;
                a2.goto = a2.A2.minus(a2.A2.ONE().scaled(a2.lambda));
                a2.enum = Constants.unitRoundOff();
            }

            @Override
            public boolean toStop(Vector v) {
                double a2;
                Vector a3 = this.goto.multiply(v);
                double a4 = a3.norm(Double.POSITIVE_INFINITY);
                return a4 <= this.enum * (a2 = MatrixMeasure.max(A2));
            }
        });
    }

    public InverseIteration(Matrix A2, double lambda, StoppingCriterion criterion) {
        this.class = new ImmutableMatrix(A2);
        this.goto = criterion;
        Matrix a2 = A2.minus(A2.ONE().scaled(lambda));
        this.enum = new ImmutableMatrix(new Inverse(a2, 0.0));
    }

    public static interface StoppingCriterion {
        public boolean toStop(Vector var1);
    }
}

