/*
 * Decompiled with CFR 0.152.
 */
package tech.nmfin.trend.dai2011;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.linearsystem.ThomasAlgorithm;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.TridiagonalMatrix;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.analysis.differentialequation.pde.finitedifference.parabolic.dim1.convectiondiffusionequation.ConvectionDiffusionEquation1D;
import dev.nm.analysis.differentialequation.pde.finitedifference.parabolic.dim1.convectiondiffusionequation.CrankNicolsonConvectionDiffusionEquation1D;
import dev.nm.analysis.function.rn2r1.AbstractBivariateRealFunction;
import dev.nm.analysis.function.rn2r1.BivariateRealFunction;
import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import tech.nmfin.trend.dai2011.Dai2011HMM;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Dai2011Solver {
    private final Dai2011HMM byte;
    private final ConvectionDiffusionEquation1D null;
    private static final double this = 1.0E-6;
    private final double if;
    private final UnivariateRealFunction do;
    private final double float;
    private static final int try = 10;
    private final int for;
    private final CrankNicolsonConvectionDiffusionEquation1D.Coefficients short;
    private final double false;
    private final int long;
    private final CrankNicolsonConvectionDiffusionEquation1D.Coefficients int;
    private final double new;
    private final TridiagonalMatrix super;
    private final BivariateRealFunction final;
    private final Vector break;
    private final BivariateRealFunction else;
    private final BivariateRealFunction catch;
    private final Vector const;
    private final ConvectionDiffusionEquation1D void;
    private static final double class = 1.0E7;
    private final double goto;
    private final BivariateRealFunction enum;

    static {
        Package.validate("ALGOQUANT_DAI2011");
    }

    private Vector[] do(Vector a2, Vector[] a3, Vector a4, Vector a5) {
        Vector[] a6 = new Vector[]{a3[0].deepCopy(), a3[1].deepCopy()};
        double a7 = Double.POSITIVE_INFINITY;
        double a8 = Double.POSITIVE_INFINITY;
        for (int a9 = 0; a9 < 10; ++a9) {
            Dai2011Solver a10;
            Vector a11 = a6[1].minus(a6[0]);
            Matrix a12 = a10.super.deepCopy();
            Matrix a13 = a10.super.deepCopy();
            Vector a14 = a4.deepCopy();
            Vector a15 = a5.deepCopy();
            boolean a16 = false;
            boolean a17 = false;
            for (int a18 = 1; a18 <= a10.long; ++a18) {
                if (a11.get(a18) + a2.get(a18) > 2.0 * a10.false) {
                    a16 = true;
                    ((TridiagonalMatrix)a12).set(a18, a18, ((TridiagonalMatrix)a12).get(a18, a18) + 1.0E7 * a10.new / 2.0);
                    a14.set(a18, a14.get(a18) + 1.0E7 * a10.new * (a6[1].get(a18) / 2.0 + a2.get(a18) / 2.0 - a10.false));
                    continue;
                }
                if (!(a11.get(a18) + a2.get(a18) < 2.0 * a10.goto)) continue;
                a17 = true;
                ((TridiagonalMatrix)a13).set(a18, a18, ((TridiagonalMatrix)a13).get(a18, a18) + 1.0E7 * a10.new / 2.0);
                a15.set(a18, a15.get(a18) + 1.0E7 * a10.new * (a6[0].get(a18) / 2.0 - a2.get(a18) / 2.0 + a10.goto));
            }
            if (a16) {
                a7 = a6[0].norm();
                a6[0] = new ThomasAlgorithm().solve((TridiagonalMatrix)a12, a14);
                a7 = Math.abs(a7 / a6[0].norm() - 1.0);
            }
            if (a17) {
                a8 = a6[1].norm();
                a6[1] = new ThomasAlgorithm().solve((TridiagonalMatrix)a13, a15);
                a8 = Math.abs(a8 / a6[1].norm() - 1.0);
            }
            if (a7 < 1.0E-6 && a8 < 1.0E-6) break;
        }
        return a6;
    }

    private double do(Vector a2, double a3) {
        Dai2011Solver a4;
        for (int a5 = a4.long / 10; a5 < a4.long; ++a5) {
            if (!(a2.get(a5) > a3)) continue;
            double a6 = a4.float * (double)a5;
            return a6;
        }
        return a4.float * (double)(a4.long - 1);
    }

    private Vector[] do(Vector a2, Vector a3) {
        Dai2011Solver a4;
        Vector[] a5 = new DenseVector[2];
        Vector a6 = a4.int.getRHS(a2, 0.0);
        a5[0] = new ThomasAlgorithm().solve(a4.super, a6);
        Vector a7 = a4.short.getRHS(a3, 0.0);
        a5[1] = new ThomasAlgorithm().solve(a4.super, a7);
        Vector a8 = a3.minus(a2);
        Vector[] a9 = a4.do(a8, a5, a6, a7);
        return a9;
    }

    private Dai2011Solver(Builder a2) {
        Dai2011Solver a3;
        a3.final = new AbstractBivariateRealFunction(){

            @Override
            public double evaluate(double t, double p) {
                double a2 = -(Dai2011Solver.this.byte.lambda1() + Dai2011Solver.this.byte.lambda2()) * p + Dai2011Solver.this.byte.lambda2();
                return -a2;
            }
            {
                1 a3;
            }
        };
        a3.enum = new AbstractBivariateRealFunction(){
            {
                2 a3;
            }

            @Override
            public double evaluate(double t, double p) {
                double a2 = (Dai2011Solver.this.byte.mu1() - Dai2011Solver.this.byte.mu2()) * p * (1.0 - p) / Dai2011Solver.this.byte.sigma();
                a2 = a2 * a2 / 2.0;
                return a2;
            }
        };
        a3.do = new AbstractUnivariateRealFunction(){
            {
                3 a3;
            }

            @Override
            public double evaluate(double p) {
                return 0.0;
            }
        };
        a3.catch = new AbstractBivariateRealFunction(){

            @Override
            public double evaluate(double t, double p) {
                return Dai2011Solver.this.if;
            }
            {
                4 a3;
            }
        };
        a3.else = new AbstractBivariateRealFunction(){
            {
                5 a3;
            }

            @Override
            public double evaluate(double t, double p) {
                double a2 = (Dai2011Solver.this.byte.mu1() - Dai2011Solver.this.byte.mu2()) * p;
                a2 += Dai2011Solver.this.byte.mu2();
                return a2 -= Dai2011Solver.this.byte.sigma() * Dai2011Solver.this.byte.sigma() / 2.0;
            }
        };
        a3.byte = a2.goto;
        a3.if = a2.catch;
        a3.false = a2.class;
        a3.goto = a2.const;
        a3.new = a2.else;
        a3.float = a2.enum;
        a3.for = (int)(1.0 / a3.new);
        a3.long = (int)(1.0 / a3.float) + 1;
        if (a3.long < 50) {
            throw new IllegalArgumentException("spatial step size is too large!");
        }
        a3.void = new ConvectionDiffusionEquation1D(a3.enum, a3.final, a3.catch, 1.0, 1.0, a3.do, 1.0, a3.do, 1.0, a3.do);
        double[] a4 = DoubleUtils.seq(0.0, a3.void.a(), a3.long + 2);
        a3.int = new CrankNicolsonConvectionDiffusionEquation1D.Coefficients(a3.void, a3.for, a3.long, a4);
        a3.super = a3.int.getLHS(0.0);
        a3.null = new ConvectionDiffusionEquation1D(a3.enum, a3.final, a3.else, 1.0, 1.0, a3.do, 1.0, a3.do, 1.0, a3.do);
        a3.short = new CrankNicolsonConvectionDiffusionEquation1D.Coefficients(a3.null, a3.for, a3.long, a4);
        a3.break = new DenseVector(a3.for);
        a3.const = new DenseVector(a3.for);
    }

    public Boundaries solve() {
        Vector a2 = new DenseVector(this.long);
        Vector a3 = new DenseVector(this.long, this.goto);
        for (int a4 = this.for; a4 >= 1; --a4) {
            Vector[] a5 = this.do(a2, a3);
            Vector a6 = a5[1].minus(a5[0]);
            this.break.set(a4, this.do(a6, this.false - 1.0E-6));
            this.const.set(a4, this.do(a6, this.goto + 1.0E-6));
            a2 = a5[0].deepCopy();
            a3 = a5[1].deepCopy();
        }
        Boundaries a7 = new Boundaries(this.break, this.const);
        return a7;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Builder {
        private double else = 1.0E-4;
        private final double catch;
        private double const;
        private static final double void = 0.0025;
        private double class = Math.log(1.0025);
        private final Dai2011HMM goto;
        private double enum = 0.001;

        public Builder(Dai2011HMM model, double rho) {
            this.const = Math.log(0.9975);
            this.goto = model;
            this.catch = rho;
        }

        public Builder commission(double K2) {
            this.class = Math.log(1.0 + K2);
            this.const = Math.log(1.0 - K2);
            return this;
        }

        public Builder commission(double Kb, double Ks) {
            this.class = Math.log(1.0 + Kb);
            this.const = Math.log(1.0 - Ks);
            return this;
        }

        public Builder grid(double dt, double dp) {
            this.else = dt;
            this.enum = dp;
            return this;
        }

        public Dai2011Solver build() {
            return new Dai2011Solver(this);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Boundaries {
        private final Vector goto;
        private final Vector enum;

        private Boundaries(Vector a2, Vector a3) {
            Boundaries a4;
            a4.goto = a2;
            a4.enum = a3;
        }

        public double getSellThreshold() {
            return this.do(this.enum);
        }

        public double getBuyThreshold() {
            return this.do(this.goto);
        }

        private double do(Vector a2) {
            int a3 = a2.size();
            int a4 = a3 / 10;
            int a5 = a3 - a3 / 10;
            double a6 = 0.0;
            int a7 = 0;
            for (int a8 = a4; a8 < a5; ++a8) {
                a6 += a2.get(a8);
                ++a7;
            }
            return a6 / (double)a7;
        }
    }
}

