/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.timeseries.linear.univariate.stationaryprocess.garch;

import dev.nm.analysis.function.FunctionOps;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.number.doublearray.DoubleArrayMath;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GARCHModel {
    private double[] class;
    private double[] goto;
    private double enum;

    public int p() {
        return this.class.length;
    }

    public double[] beta() {
        return Arrays.copyOf(this.class, this.class.length);
    }

    public GARCHModel(GARCHModel that) {
        this.enum = that.enum;
        this.goto = Arrays.copyOf(that.goto, that.goto.length);
        this.class = Arrays.copyOf(that.class, that.class.length);
    }

    public int q() {
        return this.goto.length;
    }

    public int maxPQ() {
        return Math.max(this.p(), this.q());
    }

    public double a0() {
        return this.enum;
    }

    public GARCHModel(double a0, double[] a2, double[] b2) {
        int a3;
        ArgumentAssertion.assertPositive(a0, "a0");
        ArgumentAssertion.assertNonNegative(DoubleArrayMath.min(a2), "{a}");
        ArgumentAssertion.assertNonNegative(DoubleArrayMath.min(b2), "{b}");
        double a4 = 0.0;
        for (a3 = 0; a3 < a2.length; ++a3) {
            a4 += a2[a3];
        }
        for (a3 = 0; a3 < b2.length; ++a3) {
            a4 += b2[a3];
        }
        ArgumentAssertion.assertLessThan(a4, 1.0, "sum of alpha and beta (except for alpha0)");
        this.enum = a0;
        this.goto = Arrays.copyOf(a2, a2.length);
        this.class = Arrays.copyOf(b2, b2.length);
    }

    public double[] alpha() {
        return Arrays.copyOf(this.goto, this.goto.length);
    }

    public String toString() {
        int a2;
        StringBuilder a3 = new StringBuilder();
        a3.append(this.enum);
        for (a2 = 0; a2 < this.goto.length; ++a2) {
            a3.append(String.format("+ %f * e_{t-%d}", this.goto[a2], a2 + 1));
        }
        for (a2 = 0; a2 < this.class.length; ++a2) {
            a3.append(String.format("+ %f * h_{t-%d}", this.class[a2], a2 + 1));
        }
        return a3.toString();
    }

    public double var() {
        int a2;
        double a3 = 1.0;
        for (a2 = 0; a2 < this.q(); ++a2) {
            a3 -= this.goto[a2];
        }
        for (a2 = 0; a2 < this.p(); ++a2) {
            a3 -= this.class[a2];
        }
        ArgumentAssertion.assertTrue((a3 = this.enum / a3) > 0.0, "invalid GARCH specification (except alpha0), sum of alpha and beta < 1; invalid variance", new Object[0]);
        return a3;
    }

    public double sigma2(double[] e2, double[] sigma2_lag) {
        double a2 = this.enum + FunctionOps.dotProduct(this.goto, e2) + FunctionOps.dotProduct(this.class, sigma2_lag);
        return a2;
    }

    static {
        Package.validate("NMDEV_STAT");
    }
}

