/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.timeseries.datastructure.univariate.realtime.inttime;

import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import dev.nm.stat.timeseries.datastructure.univariate.realtime.inttime.IntTimeTimeSeries;
import java.util.Arrays;
import java.util.Iterator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SimpleTimeSeries
implements IntTimeTimeSeries {
    private final double[] enum;

    public SimpleTimeSeries diff(int d2) {
        double[] a2 = this.toArray();
        return new SimpleTimeSeries(DoubleUtils.diff(a2, 1, d2));
    }

    @Override
    public Iterator<IntTimeTimeSeries.Entry> iterator() {
        return new Iterator<IntTimeTimeSeries.Entry>(){
            private int enum = 0;

            @Override
            public boolean hasNext() {
                return this.enum < SimpleTimeSeries.this.enum.length;
            }
            {
                1 a3;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("time series is immutable");
            }

            @Override
            public IntTimeTimeSeries.Entry next() {
                Double a2 = SimpleTimeSeries.this.enum[this.enum];
                return new IntTimeTimeSeries.Entry(++this.enum, (double)a2);
            }
        };
    }

    public SimpleTimeSeries lag(int nLags, int length) {
        ArgumentAssertion.assertNonNegative(nLags, "nLags");
        int a2 = this.size() - nLags - length + 1;
        ArgumentAssertion.assertTrue(a2 >= 1, "lagged series length is too long", new Object[0]);
        double[] a3 = new double[length];
        for (int a4 = a2; a4 <= this.size() - nLags; ++a4) {
            a3[a4 - a2] = this.enum[a4 - 1];
        }
        return new SimpleTimeSeries(a3);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleTimeSeries a2 = (SimpleTimeSeries)obj;
        return Arrays.equals(this.enum, a2.enum);
    }

    @Override
    public double[] toArray() {
        return (double[])this.enum.clone();
    }

    public SimpleTimeSeries lag(int nLags) {
        return this.lag(nLags, this.size() - nLags);
    }

    public SimpleTimeSeries(double[] values) {
        this.enum = (double[])values.clone();
    }

    @Override
    public int size() {
        return this.enum.length;
    }

    static {
        Package.validate("NMDEV_BASIC");
    }

    @Override
    public double get(int t) {
        return this.enum[t - 1];
    }

    public String toString() {
        int a2 = 20;
        StringBuilder a3 = new StringBuilder();
        a3.append(String.format("length = %d\n", this.enum.length));
        for (int a4 = 1; a4 <= this.enum.length; ++a4) {
            a3.append(String.format("[%d,] ", a4));
            a3.append(String.format("%f, ", this.enum[a4 - 1]));
            if (a4 % 20 != 0) continue;
            a3.append("\n");
        }
        return a3.toString();
    }

    public int hashCode() {
        int a2 = 7;
        a2 = 41 * a2 + Arrays.hashCode(this.enum);
        return a2;
    }

    public SimpleTimeSeries drop(int nItems) {
        return this.lag(0, this.size() - nItems);
    }
}

