/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.regression.linear.residualanalysis;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.CongruentMatrix;
import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.algebra.linear.vector.doubles.operation.VectorFactory;
import dev.nm.number.doublearray.DoubleArrayMath;
import dev.nm.stat.regression.linear.LMProblem;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LMResiduals {
    private final ImmutableVector const;
    private final ImmutableVector void;
    private final int class;
    private final LMProblem goto;
    private final int enum;

    public LMProblem getProblem() {
        return this.goto;
    }

    public ImmutableMatrix hHat() {
        CongruentMatrix a2 = new CongruentMatrix(this.goto.wA().t(), this.goto.invOfwAtwA());
        return new ImmutableMatrix(a2);
    }

    public ImmutableVector weightedResiduals() {
        ImmutableVector a2 = this.goto.weights() != null ? new ImmutableVector(this.goto.wy().minus(this.weightedFittedValues())) : this.residuals();
        return new ImmutableVector(a2);
    }

    public ImmutableVector leverage() {
        Vector a2 = VectorFactory.diagonal(this.hHat());
        return new ImmutableVector(a2);
    }

    public double AR2() {
        int a2 = this.df();
        double a3 = 1.0 - (double)(this.class - (this.getProblem().intercept() ? 1 : 0)) / (double)a2 * (1.0 - this.R2());
        return a3;
    }

    public double TSS() {
        Vector a2 = this.goto.weights() != null ? this.goto.weights() : new DenseVector(this.class, 1.0);
        double a3 = DoubleArrayMath.sum(this.goto.y().multiply(a2).toArray());
        Vector a4 = this.goto.y().minus((a3 /= DoubleArrayMath.sum(a2.toArray())) * (double)(this.goto.intercept() ? 1 : 0));
        double a5 = DoubleArrayMath.sum(a4.multiply(a4).multiply(a2).toArray());
        return a5;
    }

    public double stderr() {
        int a2 = this.df();
        double a3 = Math.sqrt(this.RSS() / (double)a2);
        return a3;
    }

    public LMResiduals(LMProblem problem, Vector fitted) {
        this.goto = problem;
        this.class = problem.nObs();
        this.enum = problem.nFactors();
        this.void = new ImmutableVector(fitted);
        this.const = new ImmutableVector(problem.y().minus(fitted));
    }

    public ImmutableVector residuals() {
        return this.const;
    }

    public ImmutableVector weightedFittedValues() {
        Vector a2;
        ImmutableVector a3 = this.goto.weights();
        if (a3 != null) {
            Vector a4 = a3.pow(0.5);
            DiagonalMatrix a5 = new DiagonalMatrix(a4.toArray());
            a2 = a5.multiply(this.fitted());
        } else {
            a2 = this.fitted();
        }
        return new ImmutableVector(a2);
    }

    public double Fstat() {
        int a2 = this.df();
        double a3 = this.TSS();
        double a4 = this.RSS();
        double a5 = (a3 - a4) / (double)(this.enum - (this.getProblem().intercept() ? 1 : 0)) / (a4 / (double)a2);
        return a5;
    }

    public ImmutableVector fitted() {
        return this.void;
    }

    public ImmutableVector studentized() {
        int a2 = this.df();
        ImmutableVector a3 = this.standardized();
        double[] a4 = new double[this.class];
        for (int a5 = 0; a5 < this.class; ++a5) {
            double a6 = a3.get(a5 + 1);
            a4[a5] = a6 * Math.sqrt((double)(a2 - 1) / ((double)a2 - a6 * a6));
        }
        return new ImmutableVector(new DenseVector(a4));
    }

    public double RSS() {
        double a2 = this.weightedResiduals().norm();
        double a3 = a2 * a2;
        return a3;
    }

    public double R2() {
        double a2 = 1.0 - this.RSS() / this.TSS();
        return a2;
    }

    public int df() {
        return this.class - this.enum;
    }

    public ImmutableVector standardized() {
        int a2 = this.df();
        Vector a3 = this.leverage().minus(1.0).scaled(-1.0).pow(0.5);
        Vector a4 = this.weightedResiduals().divide(a3);
        a4 = a4.scaled(Math.sqrt(1.0 / (this.RSS() / (double)a2)));
        ImmutableVector a5 = new ImmutableVector(a4);
        return a5;
    }
}

