/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.regression.linear.panel;

import dev.nm.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import dev.nm.number.DoubleUtils;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PanelData<S, T extends Comparable<? super T>> {
    private final String const;
    private final String void;
    private final Map<S, TreeSet<Row>> class;
    private final Map<Key, Row> goto = new TreeMap<Key, Row>();
    private final String[] enum;

    public String getExtHeadersString() {
        StringBuilder a2 = new StringBuilder();
        for (String a3 : this.getExtHeaders()) {
            a2.append(a3).append(", ");
        }
        return a2.toString();
    }

    public String[] getValueHeaders() {
        return Arrays.copyOf(this.enum, this.enum.length);
    }

    public static <S> PanelData<S, Year> yearPanelData(String subjectHeader, String timeHeader, String[] headers) {
        return new PanelData(subjectHeader, timeHeader, headers);
    }

    public void addRow(Row row) {
        this.goto.put(row.goto, row);
        TreeSet<Row> a2 = this.class.get(row.subject());
        if (a2 == null) {
            a2 = new TreeSet();
            this.class.put(row.subject(), a2);
        }
        a2.add(row);
    }

    public List<Row> getRowsForSubject(S subject) {
        if (!this.class.containsKey(subject)) {
            return null;
        }
        TreeSet<Row> a2 = this.class.get(subject);
        return Collections.unmodifiableList(new ArrayList<Row>(a2));
    }

    public String getValueHeadersString() {
        StringBuilder a2 = new StringBuilder();
        for (String a3 : this.enum) {
            a2.append(a3).append(", ");
        }
        return a2.toString();
    }

    public boolean isBalanced() {
        List<S> a2 = this.getAllSubjects();
        int a3 = this.class.get(a2.get(0)).size();
        for (int a4 = 1; a4 < a2.size(); ++a4) {
            if (a3 == this.class.get(a2.get(a4)).size()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.goto.values().toString();
    }

    public double[][] getPanelValuesByTime(List<Row> rows) {
        return this.getPanelValuesByTime(rows, this.enum, new Transformation[0]);
    }

    public static <S> PanelData<S, Instant> instantPanelData(String subjectHeader, String timeHeader, String[] headers) {
        return new PanelData(subjectHeader, timeHeader, headers);
    }

    protected PanelData(String subjectHeader, String timeHeader, String[] headers) {
        this.class = new LinkedHashMap<S, TreeSet<Row>>();
        this.void = subjectHeader;
        this.const = timeHeader;
        this.enum = Arrays.copyOf(headers, headers.length);
    }

    public static <S> PanelData<S, LocalDate> localDatePanelData(String subjectHeader, String timeHeader, String[] headers) {
        return new PanelData(subjectHeader, timeHeader, headers);
    }

    public List<S> getAllSubjects() {
        return new ArrayList<S>(this.class.keySet());
    }

    public String[] getExtHeaders() {
        String[] a2 = new String[2 + this.enum.length];
        a2[0] = this.void;
        a2[1] = this.const;
        for (int a3 = 2; a3 < a2.length; ++a3) {
            a2[a3] = this.enum[a3 - 2];
        }
        return a2;
    }

    public Row getRow(S subject, T time) {
        return this.goto.get(new Key(subject, (Comparable)time));
    }

    public double[][] getPanelValuesByTime(List<Row> rows, String[] headers, Transformation[] transformations) {
        int a2 = rows.size();
        int a3 = headers.length;
        HashMap<String, Transformation> a4 = new HashMap<String, Transformation>();
        for (Transformation a5 : transformations) {
            a4.put(a5.header(), a5);
        }
        double[][] a6 = new double[a2][a3];
        for (int a7 = 0; a7 < a2; ++a7) {
            Row a8 = rows.get(a7);
            for (int a9 = 0; a9 < a3; ++a9) {
                String a10 = headers[a9];
                Transformation a11 = (Transformation)a4.get(a10);
                double a12 = a8.get(a10);
                if (a11 != null) {
                    a12 = a11.f().evaluate(a12);
                }
                a6[a7][a9] = a12;
            }
        }
        return a6;
    }

    public double[][] getPanelValuesByHeaders(List<Row> rows) {
        return this.getPanelValuesByHeaders(rows, this.enum, new Transformation[0]);
    }

    public double[][] getPanelValuesByHeaders(List<Row> rows, String[] headers, Transformation[] transformations) {
        int a2 = rows.size();
        int a3 = headers.length;
        HashMap<String, Transformation> a4 = new HashMap<String, Transformation>();
        for (Transformation a5 : transformations) {
            a4.put(a5.header(), a5);
        }
        double[][] a6 = new double[a3][a2];
        for (int a7 = 0; a7 < a3; ++a7) {
            Transformation a5;
            String a8 = headers[a7];
            a5 = (Transformation)a4.get(a8);
            for (int a9 = 0; a9 < a2; ++a9) {
                Row a10 = rows.get(a9);
                double a11 = a10.get(a8);
                if (a5 != null) {
                    a11 = a5.f().evaluate(a11);
                }
                a6[a7][a9] = a11;
            }
        }
        return a6;
    }

    public static <S> PanelData<S, LocalDateTime> localDateTimePanelData(String subjectHeader, String timeHeader, String[] headers) {
        return new PanelData(subjectHeader, timeHeader, headers);
    }

    public void addRow(S subject, T time, double ... values) {
        Row a2 = new Row((Object)subject, (Comparable)time, values);
        this.addRow(a2);
    }

    public List<Row> getRows() {
        return Collections.unmodifiableList(new ArrayList<Row>(this.goto.values()));
    }

    public double[][] getPanelValuesByHeaders(List<Row> rows, String[] headers) {
        return this.getPanelValuesByHeaders(rows, headers, new Transformation[0]);
    }

    public static <S> PanelData<S, YearMonth> yearMonthPanelData(String subjectHeader, String timeHeader, String[] headers) {
        return new PanelData(subjectHeader, timeHeader, headers);
    }

    public int size() {
        return this.goto.size();
    }

    public static interface Transformation {
        public String header();

        public UnivariateRealFunction f();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class Row
    implements Comparable<Row> {
        private final Key goto;
        private final LinkedHashMap<String, Double> enum = new LinkedHashMap();

        public String time() {
            return this.goto.enum.toString();
        }

        private Row(S a3, Comparable a4, double ... a5) {
            Row a6;
            a6.goto = new Key(a3, a4);
            for (int a7 = 0; a7 < a6.PanelData.this.enum.length; ++a7) {
                a6.do(a6.PanelData.this.enum[a7], a5[a7]);
            }
        }

        public S subject() {
            return this.goto.goto;
        }

        public double get(String header) {
            return this.enum.get(header);
        }

        public double[] values() {
            double[] a2 = DoubleUtils.collection2DoubleArray(this.enum.values());
            return a2;
        }

        @Override
        public int compareTo(Row that) {
            return this.goto.compareTo(that.goto);
        }

        private void do(String a2, double a3) {
            Row a4;
            a4.enum.put(a2, a3);
        }

        public String toString() {
            StringBuilder a2 = new StringBuilder(this.goto.toString());
            for (Double a3 : this.enum.values()) {
                a2.append(a3).append(", ");
            }
            return a2.toString();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class Key
    implements Comparable<Key> {
        private final Object goto;
        private final Comparable enum;

        public String toString() {
            String a2 = String.format("[%s,%s]: ", this.goto.toString(), this.enum);
            return a2;
        }

        @Override
        public int compareTo(Key that) {
            int a2 = Comparable.class.isAssignableFrom(this.goto.getClass()) ? ((Comparable)this.goto).compareTo((Comparable)that.goto) : this.goto.toString().compareTo(that.goto.toString());
            if (a2 != 0) {
                return a2;
            }
            return this.enum.compareTo(that.enum);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key a2 = (Key)obj;
            if (this.enum == null ? a2.enum != null : !this.enum.equals(a2.enum)) {
                return false;
            }
            return this.goto == a2.goto || this.goto != null && this.goto.equals(a2.goto);
        }

        public int hashCode() {
            int a2 = 3;
            a2 = 89 * a2 + (this.goto != null ? this.goto.hashCode() : 0);
            a2 = 89 * a2 + (this.enum != null ? this.enum.hashCode() : 0);
            return a2;
        }

        private Key(Object a2, Comparable a3) {
            Key a4;
            a4.goto = a2;
            a4.enum = a3;
        }
    }
}

