/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.regression.linear.logistic;

import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.algebra.linear.vector.doubles.operation.VectorFactory;
import dev.nm.analysis.function.rn2r1.RealScalarFunction;
import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import dev.nm.number.DoubleUtils;
import dev.nm.stat.descriptive.moment.Mean;
import dev.nm.stat.regression.linear.glm.distribution.GLMBinomial;
import dev.nm.stat.regression.linear.glm.distribution.GLMFamily;
import dev.nm.stat.regression.linear.logistic.LogisticProblem;
import dev.nm.stat.regression.linear.logistic.LogisticRegression;
import dev.nm.stat.regression.linear.residualanalysis.LMResiduals;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LogisticResiduals
extends LMResiduals {
    private final ImmutableVector enum;

    public double deviance() {
        RealScalarFunction a2 = LogisticRegression.logLikelihood((LogisticProblem)this.getProblem());
        double a3 = (Double)a2.evaluate(this.enum);
        double a4 = -2.0 * a3;
        return a4;
    }

    LogisticResiduals(LogisticProblem a2, Vector a3) {
        super(a2, LogisticResiduals.do(a2.A().multiply(a3)));
        LogisticResiduals a4;
        a4.enum = new ImmutableVector(a3);
    }

    public ImmutableVector devianceResiduals() {
        int a2 = this.getProblem().y().size();
        GLMFamily a3 = new GLMFamily(new GLMBinomial());
        double[] a4 = new double[a2];
        for (int a5 = 1; a5 <= a2; ++a5) {
            double a6 = this.getProblem().y().get(a5);
            double a7 = this.fitted().get(a5);
            double a8 = a3.distribution().deviance(a6, a7);
            a4[a5 - 1] = a6 > a7 ? Math.sqrt(a8) : -Math.sqrt(a8);
        }
        DenseVector a9 = new DenseVector(a4);
        return new ImmutableVector(a9);
    }

    private static Vector do(Vector a2) {
        return VectorFactory.foreach(a2, (UnivariateRealFunction)new AbstractUnivariateRealFunction(){
            {
                1 a2;
            }

            @Override
            public double evaluate(double x) {
                return 1.0 / (1.0 + Math.exp(-x));
            }
        });
    }

    public double nullDeviance() {
        int a2 = this.getProblem().nFactors();
        RealScalarFunction a3 = LogisticRegression.logLikelihood((LogisticProblem)this.getProblem());
        double a4 = new Mean(this.getProblem().y().toArray()).value();
        double a5 = Math.log(a4 / (1.0 - a4));
        double[] a6 = DoubleUtils.rep(0.0, a2);
        a6[a2 - 1] = a5;
        double a7 = -2.0 * (Double)a3.evaluate(new DenseVector(a6));
        return a7;
    }
}

