/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.regression.linear.glm.modelselection;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.number.DoubleUtils;
import dev.nm.number.doublearray.DoubleArrayMath;
import dev.nm.stat.distribution.univariate.NormalDistribution;
import dev.nm.stat.regression.linear.glm.GLMProblem;
import dev.nm.stat.regression.linear.glm.GeneralizedLinearModel;
import dev.nm.stat.regression.linear.glm.modelselection.BackwardElimination;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EliminationByZValue
implements BackwardElimination.Step {
    private final double enum;

    @Override
    public int eliminate(GLMProblem problem, Matrix subA) {
        int a2;
        GLMProblem a3 = new GLMProblem((Vector)problem.y(), subA, problem.intercept(), problem.getFamily());
        GeneralizedLinearModel a4 = new GeneralizedLinearModel(a3);
        double[] a5 = a4.beta().t().toArray();
        double a6 = Math.abs(a5[a2 = DoubleUtils.minIndex(true, 0, subA.nCols(), DoubleArrayMath.abs(a5))]);
        if (a6 < this.enum) {
            return a2 + 1;
        }
        return -1;
    }

    public EliminationByZValue(double significance) {
        ArgumentAssertion.assertRange(significance, 0.0, 1.0, "significance level");
        this.enum = new NormalDistribution(0.0, 1.0).quantile(1.0 - significance / 2.0);
    }
}

