/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.factor.factoranalysis;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.Eigen;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.Inverse;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.analysis.function.rn2r1.AbstractRealScalarFunction;
import dev.nm.analysis.function.rn2r1.RealScalarFunction;
import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.analysis.function.rn2rm.RealVectorFunction;
import dev.nm.misc.PrecisionUtils;
import dev.nm.number.DoubleUtils;
import dev.nm.number.doublearray.DoubleArrayMath;
import dev.nm.solver.multivariate.constrained.constraint.linear.LinearConstraints;
import dev.nm.solver.multivariate.constrained.constraint.linear.LinearLessThanConstraints;
import dev.nm.solver.multivariate.constrained.constraint.linear.LowerBoundConstraints;
import dev.nm.solver.multivariate.constrained.constraint.linear.UpperBoundConstraints;
import dev.nm.solver.multivariate.constrained.general.sqp.activeset.SQPActiveSetMinimizer;
import dev.nm.solver.multivariate.constrained.problem.ConstrainedOptimProblemImpl1;
import dev.nm.solver.multivariate.unconstrained.c2.NelderMeadMinimizer;
import dev.nm.solver.problem.C2OptimProblemImpl;
import dev.nm.stat.factor.factoranalysis.FactorAnalysis;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class FactorAnalysisMLE {
    private static final double else = 0.005;
    private static final double catch = 1.0E10;
    private final int const;
    final RealScalarFunction nL;
    private final ImmutableMatrix void;
    private final Gradient class;
    private final int goto;
    private final double enum;

    Vector estimate(Vector a2) {
        FactorAnalysisMLE a3;
        Vector a4 = a2;
        try {
            SQPActiveSetMinimizer a5 = new SQPActiveSetMinimizer(a3.enum, a3.enum, a3.const);
            ConstrainedOptimProblemImpl1 a6 = new ConstrainedOptimProblemImpl1(a3.nL, null, (LinearLessThanConstraints)LinearConstraints.concat(new LowerBoundConstraints(a3.nL, 0.005).toLessThanConstraints(), new UpperBoundConstraints(a3.nL, 1.0)));
            SQPActiveSetMinimizer.Solution a7 = a5.solve(a6);
            a7.search((S[])new Vector[]{a4});
            a4 = (Vector)a7.minimizer();
        }
        catch (Exception a8) {
            RealScalarFunction a9 = new RealScalarFunction(){

                @Override
                public int dimensionOfDomain() {
                    return FactorAnalysisMLE.this.nL.dimensionOfDomain();
                }

                @Override
                public int dimensionOfRange() {
                    return FactorAnalysisMLE.this.nL.dimensionOfRange();
                }
                {
                    1 a3;
                }

                @Override
                public Double evaluate(Vector psi) {
                    double[] a2 = psi.toArray();
                    double a3 = DoubleArrayMath.min(a2);
                    if (a3 < 0.005) {
                        return 1.0E10;
                    }
                    double a4 = DoubleArrayMath.max(a2);
                    if (a4 > 1.0) {
                        return 1.0E10;
                    }
                    double a5 = (Double)FactorAnalysisMLE.this.nL.evaluate(psi);
                    return a5;
                }
            };
            C2OptimProblemImpl a10 = new C2OptimProblemImpl(a9);
            NelderMeadMinimizer a11 = new NelderMeadMinimizer(a3.enum, a3.const);
            NelderMeadMinimizer.Solution a12 = a11.solve(a10);
            a4 = a12.search(a4);
        }
        if (DoubleArrayMath.min(a4.toArray()) < 0.005 - a3.enum) {
            throw new RuntimeException(String.format("invalid psi: %s", a4.toString()));
        }
        return a4;
    }

    FactorAnalysisMLE(Matrix a2, int a3) {
        a4(a2, a3, Gradient.ANALYTICAL, PrecisionUtils.autoEpsilon(a2), 500);
        FactorAnalysisMLE a4;
    }

    FactorAnalysisMLE(Matrix a2, int a3, Gradient a4, double a5, int a6) {
        FactorAnalysisMLE a7;
        a7.void = new ImmutableMatrix(a2);
        a7.goto = a3;
        a7.class = a4;
        a7.enum = a5;
        a7.const = a6;
        a7.nL = a7.new logLikelihood();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class GradientFunction
    implements RealVectorFunction {
        private final int enum;

        @Override
        public Vector evaluate(Vector psi) {
            Matrix a2 = FactorAnalysis.getLoadings(psi, FactorAnalysisMLE.this.goto, FactorAnalysisMLE.this.void);
            DiagonalMatrix a3 = new DiagonalMatrix(psi.toArray());
            Inverse a4 = new Inverse(a3);
            Matrix a5 = a2.multiply(a2.t()).add(a3).minus(FactorAnalysisMLE.this.void);
            a5 = a4.multiply(a5).multiply(a4);
            DenseVector a6 = new DenseVector(this.enum);
            for (int a7 = 1; a7 <= this.enum; ++a7) {
                a6.set(a7, a5.get(a7, a7));
            }
            return a6;
        }

        @Override
        public int dimensionOfDomain() {
            return this.enum;
        }

        @Override
        public int dimensionOfRange() {
            return 1;
        }

        private GradientFunction() {
            GradientFunction a2;
            a2.enum = a2.FactorAnalysisMLE.this.void.nRows();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class logLikelihood
    extends AbstractRealScalarFunction {
        private final int enum;

        private logLikelihood() {
            logLikelihood a2;
            super(a2.FactorAnalysisMLE.this.void.nRows());
            a2.enum = a2.FactorAnalysisMLE.this.void.nRows();
        }

        @Override
        public Double evaluate(Vector psi) {
            double[] a2 = psi.toArray();
            DiagonalMatrix a3 = new DiagonalMatrix(DoubleUtils.foreach(a2, new AbstractUnivariateRealFunction(){

                @Override
                public double evaluate(double psi) {
                    return 1.0 / Math.sqrt(psi);
                }
                {
                    1 a3;
                }
            }));
            Matrix a4 = a3.multiply(FactorAnalysisMLE.this.void).multiply(a3);
            Eigen a5 = new Eigen(a4, Eigen.Method.QR_SYMMETRIC, FactorAnalysisMLE.this.enum);
            double[] a6 = Arrays.copyOfRange(a5.getRealEigenvalues(), FactorAnalysisMLE.this.goto, this.enum);
            double a7 = 0.0;
            for (int a8 = 0; a8 < this.enum - FactorAnalysisMLE.this.goto; ++a8) {
                if (DoubleUtils.isZero(a6[a8], FactorAnalysisMLE.this.enum)) {
                    return 1.0E10;
                }
                a7 += a6[a8] - Math.log(a6[a8]);
            }
            return a7 -= (double)(this.enum - FactorAnalysisMLE.this.goto);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static enum Gradient {
        ANALYTICAL,
        NUMERICAL;


        private Gradient() {
            Gradient a2;
        }
    }
}

