/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.evt.evd.univariate;

import dev.nm.analysis.function.special.beta.BetaRegularized;
import dev.nm.analysis.function.special.beta.BetaRegularizedInverse;
import dev.nm.analysis.function.special.beta.LogBeta;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.stat.distribution.univariate.ProbabilityDistribution;
import dev.nm.stat.evt.evd.univariate.UnivariateEVD;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class OrderStatisticsDistribution
implements UnivariateEVD {
    private final int class;
    private final int goto;
    private final ProbabilityDistribution enum;

    @Override
    public double cdf(double x) {
        double a2 = this.enum.cdf(x);
        BetaRegularized a3 = new BetaRegularized(this.goto, this.class - this.goto + 1);
        return a3.evaluate(a2);
    }

    @Override
    public double mean() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double moment(double x) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double variance() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double density(double x) {
        return Math.exp(this.logDensity(x));
    }

    @Override
    public double median() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double entropy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double skew() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static {
        Package.validate("NMDEV_EVT");
    }

    @Override
    public double quantile(double x) {
        BetaRegularizedInverse a2 = new BetaRegularizedInverse(this.goto, this.class - this.goto + 1);
        return this.enum.quantile(a2.evaluate(x));
    }

    @Override
    public double kurtosis() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public OrderStatisticsDistribution(ProbabilityDistribution dist, int nIIDs, int order) {
        ArgumentAssertion.assertPositive(nIIDs, "number of independent variables");
        ArgumentAssertion.assertPositive(order, "order");
        ArgumentAssertion.assertTrue(order <= nIIDs, "order (%d) cannot be greater than nIIDs (%d)", order, nIIDs);
        this.enum = dist;
        this.class = nIIDs;
        this.goto = order;
    }

    @Override
    public double logDensity(double x) {
        double a2 = Math.log(this.enum.density(x));
        if (Double.isInfinite(a2)) {
            return Double.NEGATIVE_INFINITY;
        }
        double a3 = this.enum.cdf(x);
        double a4 = (double)(this.goto - 1) * Math.log(a3) + (double)(this.class - this.goto) * Math.log(1.0 - a3);
        double a5 = new LogBeta().evaluate(this.goto, this.class - this.goto + 1);
        double a6 = a2 + a4 - a5;
        return a6;
    }
}

