/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.evt.evd.bivariate;

import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.analysis.root.univariate.BrentRoot;
import dev.nm.analysis.root.univariate.NoRootFoundException;
import dev.nm.analysis.root.univariate.Uniroot;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.Constants;
import dev.nm.misc.license.Package;
import dev.nm.stat.distribution.univariate.BetaDistribution;
import dev.nm.stat.evt.evd.bivariate.AbstractBivariateEVD;
import dev.nm.stat.evt.evd.univariate.GeneralizedEVD;
import dev.nm.stat.random.rng.univariate.uniform.UniformRNG;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BivariateEVDColesTawn
extends AbstractBivariateEVD {
    private final double catch;
    private static final Uniroot const;
    private final GeneralizedEVD void;
    private final UniformRNG class = new UniformRNG();
    private final GeneralizedEVD goto;
    private final double enum;

    @Override
    public double density(double x1, double x2) {
        double a2;
        double a3 = this.goto.marginalTransform(x1);
        double a4 = this.void.marginalTransform(x2);
        if (a3 == 0.0 || a4 == 0.0 || Double.isInfinite(a3) || Double.isInfinite(a4)) {
            a2 = Double.NEGATIVE_INFINITY;
        } else {
            double a5 = this.enum * a4 / (this.enum * a4 + this.catch * a3);
            double a6 = a4 * new BetaDistribution(this.enum, this.catch + 1.0).cdf(a5) + a3 * (1.0 - new BetaDistribution(this.enum + 1.0, this.catch).cdf(a5));
            double a7 = Math.log(a3);
            double a8 = Math.log(a4);
            double a9 = (1.0 + this.goto.getShape()) * a7 + (1.0 + this.void.getShape()) * a8 - Math.log(this.goto.getScale() * this.void.getScale());
            double a10 = this.enum * this.catch / (this.enum + this.catch + 1.0);
            double a11 = new BetaDistribution(this.enum, this.catch + 1.0).cdf(a5) * (1.0 - new BetaDistribution(this.enum + 1.0, this.catch).cdf(a5));
            double a12 = new BetaDistribution(this.enum + 1.0, this.catch + 1.0).density(a5) / (this.enum * a4 + this.catch * a3);
            a2 = Math.log(a11 + a10 * a12) - a6 + a9;
        }
        return Math.exp(a2);
    }

    public BivariateEVDColesTawn(double alpha, double beta, GeneralizedEVD marginal1, GeneralizedEVD marginal2) {
        ArgumentAssertion.assertPositive(alpha, "alpha");
        ArgumentAssertion.assertPositive(beta, "beta");
        this.enum = alpha;
        this.catch = beta;
        this.goto = marginal1;
        this.void = marginal2;
    }

    @Override
    public double dependence(double x) {
        ArgumentAssertion.assertRange(x, 0.0, 1.0, "x");
        double a2 = this.enum * (1.0 - x) / (this.enum * (1.0 - x) + this.catch * x);
        return (1.0 - x) * new BetaDistribution(this.enum, this.catch + 1.0).cdf(a2) + x * (1.0 - new BetaDistribution(this.enum + 1.0, this.catch).cdf(a2));
    }

    @Override
    public void seed(long ... seeds) {
        this.class.seed(seeds);
    }

    @Override
    public double[] nextVector() {
        double a2;
        final double[] a3 = new double[]{this.class.nextDouble(), this.class.nextDouble()};
        AbstractUnivariateRealFunction a4 = new AbstractUnivariateRealFunction(){
            {
                1 a32;
            }

            @Override
            public double evaluate(double x) {
                return BivariateEVDColesTawn.this.do(x, a3[1]) - a3[0];
            }
        };
        try {
            a2 = const.solve(a4, Constants.MACH_EPS, 1.0 - Constants.MACH_EPS, new double[0]);
        }
        catch (NoRootFoundException a5) {
            a2 = a5.x();
        }
        a3[0] = a2;
        double a6 = this.goto.marginalInverseTransform(-Math.log(a3[0]));
        double a7 = this.void.marginalInverseTransform(-Math.log(a3[1]));
        return new double[]{a6, a7};
    }

    private double do(double a2, double a3) {
        BivariateEVDColesTawn a4;
        double a5 = -Math.log(a2);
        double a6 = -Math.log(a3);
        double a7 = a4.enum * a6 / (a4.enum * a6 + a4.catch * a5);
        double a8 = a5 * (1.0 - new BetaDistribution(a4.enum + 1.0, a4.catch).cdf(a7)) + a6 * new BetaDistribution(a4.enum, a4.catch + 1.0).cdf(a7);
        double a9 = Math.exp(-a8) * (1.0 / a3) * new BetaDistribution(a4.enum, a4.catch + 1.0).cdf(a7);
        return a9;
    }

    public BivariateEVDColesTawn(double alpha, double beta, GeneralizedEVD marginal) {
        this(alpha, beta, marginal, marginal);
    }

    static {
        Package.validate("NMDEV_EVT");
        const = new BrentRoot(Constants.EPSILON, Integer.MAX_VALUE);
    }

    @Override
    public double conditionalCopula(double x1, double x2) {
        ArgumentAssertion.assertRangeOpen(x1, 0.0, 1.0, "x1");
        ArgumentAssertion.assertRangeOpen(x2, 0.0, 1.0, "x2");
        return this.do(x1, x2);
    }

    public BivariateEVDColesTawn(double alpha, double beta) {
        this(alpha, beta, new GeneralizedEVD());
    }

    @Override
    public double spectralDensity(double x) {
        ArgumentAssertion.assertRange(x, 0.0, 1.0, "x");
        double a2 = this.enum * x / (this.enum * x + this.catch * (1.0 - x));
        double a3 = this.enum * this.catch / (this.enum + this.catch + 1.0);
        double a4 = new BetaDistribution(this.enum + 1.0, this.catch + 1.0).density(a2) / (this.enum * x * x * (1.0 - x) + this.catch * x * (1.0 - x) * (1.0 - x)) * a3;
        return a4;
    }

    @Override
    public double cdf(double x1, double x2) {
        double a2 = this.goto.marginalTransform(x1);
        double a3 = this.goto.marginalTransform(x2);
        if (Double.isInfinite(a2) || Double.isInfinite(a3)) {
            return 0.0;
        }
        if (a2 + a3 == 0.0) {
            return 1.0;
        }
        double a4 = this.enum * a3 / (this.enum * a3 + this.catch * a2);
        double a5 = a3 * new BetaDistribution(this.enum, this.catch + 1.0).cdf(a4) + a2 * (1.0 - new BetaDistribution(this.enum + 1.0, this.catch).cdf(a4));
        return Math.exp(-a5);
    }
}

