/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.evt.cluster;

import dev.nm.misc.license.Package;
import dev.nm.number.doublearray.DoubleArrayMath;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Clusters {
    private final double[] class;
    private final int goto;
    private final List<Cluster> enum;

    public int getClusterCount() {
        return this.enum.size();
    }

    public double getAverageClusterSize() {
        return (double)this.getExceedenceCount() / (double)this.getClusterCount();
    }

    static {
        Package.validate("NMDEV_EVT");
    }

    public Clusters(double[] observations, List<Cluster> clusters, int nExceedences) {
        this.class = observations;
        this.enum = clusters;
        this.goto = nExceedences;
    }

    public double[] getClusterMaxima() {
        double[] a2 = new double[this.enum.size()];
        for (int a3 = 0; a3 < a2.length; ++a3) {
            Cluster a4 = this.enum.get(a3);
            a2[a3] = DoubleArrayMath.max(Arrays.copyOfRange(this.class, a4.getBeginIndex(), a4.getEndIndex() + 1));
        }
        return a2;
    }

    public int getExceedenceCount() {
        return this.goto;
    }

    public List<Cluster> getClusters() {
        return Collections.unmodifiableList(this.enum);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Cluster {
        private final int goto;
        private final int enum;

        public int getBeginIndex() {
            return this.goto;
        }

        public int getEndIndex() {
            return this.enum;
        }

        public String toString() {
            return String.format("[%d,%d]", this.goto, this.enum);
        }

        public Cluster(int beginIndex, int endIndex) {
            this.goto = beginIndex;
            this.enum = endIndex;
        }
    }
}

