/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.descriptive.rank;

import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import dev.nm.stat.descriptive.Statistic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Quantile
implements Statistic {
    private final List<Double> goto = new ArrayList<Double>();
    private final QuantileType enum;

    private int do(double a2, double a3) {
        Quantile a4;
        int a5 = a4.goto.size();
        int a6 = (int)Math.floor(a2 * (double)a5 + a3);
        a6 = a6 > 0 ? a6 : 0;
        a6 = a6 <= a5 ? a6 : a5;
        return a6;
    }

    @Override
    public void addData(double ... data) {
        double[] dArray = data;
        int n = dArray.length;
        for (int i2 = 0; i2 < n; ++i2) {
            Double a2 = dArray[i2];
            this.goto.add(a2);
        }
    }

    public Quantile(double[] data) {
        this(data, QuantileType.APPROXIMATELY_MEDIAN_UNBIASED);
    }

    @Override
    public double value() {
        throw new UnsupportedOperationException("you must supply a quantile value q");
    }

    private double short(double a2, double a3, double a4) {
        double a5 = a3 + a2 * (1.0 - a3 - a4);
        return a5;
    }

    @Override
    public long N() {
        return this.goto.size();
    }

    public double value(double q) {
        ArgumentAssertion.assertRange(q, 0.0, 1.0, "q");
        if (this.goto.isEmpty()) {
            return Double.NaN;
        }
        int a2 = 0;
        double a3 = 0.0;
        double a4 = 0.0;
        double a5 = 0.0;
        double a6 = 0.0;
        switch (this.enum) {
            case INVERSE_OF_EMPIRICAL_CDF: {
                a3 = 0.0;
                a2 = this.do(q, a3);
                a4 = this.do(q, a3, a2);
                a5 = DoubleUtils.isZero(a4, 0.0) ? 0.0 : 1.0;
                break;
            }
            case INVERSE_OF_EMPIRICAL_CDF_WITH_AVERAGING_AT_DISCONTINUITIES: {
                a3 = 0.0;
                a2 = this.do(q, a3);
                a4 = this.do(q, a3, a2);
                a5 = DoubleUtils.isZero(a4, 0.0) ? 0.5 : 1.0;
                break;
            }
            case NEAREST_EVEN_ORDER_STATISTICS: {
                a3 = -0.5;
                a2 = this.do(q, a3);
                a4 = this.do(q, a3, a2);
                a5 = DoubleUtils.isZero(a4, 0.0) ? (a2 % 2 == 0 ? 0.0 : 1.0) : 1.0;
                break;
            }
            case LINEAR_INTERPOLATION_OF_EMPIRICAL_CDF: {
                a3 = 0.0;
                a2 = this.do(q, a3);
                a5 = a4 = this.do(q, a3, a2);
                break;
            }
            case MIDWAY_THROUGH_STEPS_OF_EMPIRICAL_CDF: {
                a3 = 0.5;
                a2 = this.do(q, a3);
                a5 = a4 = this.do(q, a3, a2);
                break;
            }
            case MINITAB_SPSS: {
                a3 = q;
                a2 = this.do(q, a3);
                a5 = a4 = this.do(q, a3, a2);
                break;
            }
            case S: {
                a3 = 1.0 - q;
                a2 = this.do(q, a3);
                a5 = a4 = this.do(q, a3, a2);
                break;
            }
            case APPROXIMATELY_UNBIASED_IF_DATA_IS_NORMAL: {
                a3 = this.short(q, 0.375, 0.375);
                a2 = this.do(q, a3);
                a5 = a4 = this.do(q, a3, a2);
                break;
            }
            default: {
                a3 = this.short(q, 0.3333333333333333, 0.3333333333333333);
                a2 = this.do(q, a3);
                a5 = a4 = this.do(q, a3, a2);
            }
        }
        a6 = this.do(a5, a2);
        return a6;
    }

    private double do(double a2, int a3) {
        Quantile a4;
        ArrayList<Double> a5 = new ArrayList<Double>(a4.goto);
        Collections.sort(a5);
        double a6 = (1.0 - a2) * (Double)a5.get(a3 > 0 ? a3 - 1 : 0);
        return a6 += a2 * (Double)a5.get(a3 < a5.size() ? a3 : a5.size() - 1);
    }

    public Quantile(double[] data, QuantileType type) {
        this.enum = type;
        this.addData(data);
    }

    static {
        Package.validate("NMDEV_BASIC");
    }

    private double do(double a2, double a3, double a4) {
        Quantile a5;
        int a6 = a5.goto.size();
        double a7 = a2 * (double)a6 + a3 - a4;
        return a7;
    }

    public Quantile() {
        this(new double[0], QuantileType.APPROXIMATELY_MEDIAN_UNBIASED);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum QuantileType {
        INVERSE_OF_EMPIRICAL_CDF,
        INVERSE_OF_EMPIRICAL_CDF_WITH_AVERAGING_AT_DISCONTINUITIES,
        NEAREST_EVEN_ORDER_STATISTICS,
        LINEAR_INTERPOLATION_OF_EMPIRICAL_CDF,
        MIDWAY_THROUGH_STEPS_OF_EMPIRICAL_CDF,
        MINITAB_SPSS,
        S,
        APPROXIMATELY_MEDIAN_UNBIASED,
        APPROXIMATELY_UNBIASED_IF_DATA_IS_NORMAL;


        private QuantileType() {
            QuantileType a2;
        }
    }
}

