/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.descriptive.moment;

import dev.nm.analysis.function.FunctionOps;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.stat.descriptive.Statistic;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Moments
implements Statistic {
    private double[] class;
    private final int goto;
    private long enum = 0L;

    @Override
    public void addData(double ... data) {
        if (this.enum == 0L) {
            this.enum = data.length;
            this.class[0] = Moments.sumsOfPowersOfDifferences(1, 0.0, data);
            double a2 = this.class[0] / (double)this.enum;
            for (int a3 = 2; a3 <= this.goto; ++a3) {
                this.class[a3 - 1] = Moments.sumsOfPowersOfDifferences(a3, a2, data);
            }
            return;
        }
        Moments a4 = new Moments(this);
        Moments a5 = new Moments(this.goto, data);
        long a6 = a4.enum + a5.enum;
        double a7 = a5.class[0] / (double)a5.enum - a4.class[0] / (double)a4.enum;
        this.class[0] = a4.class[0] + a5.class[0];
        for (int a8 = 2; a8 <= this.goto; ++a8) {
            double a9 = 0.0;
            for (int a10 = 1; a10 <= a8 - 2; ++a10) {
                int a11 = a8 - a10;
                double a12 = Math.pow((double)(-a5.enum) / (double)a6, a10) * a4.class[a11 - 1];
                a12 += Math.pow((double)a4.enum / (double)a6, a10) * a5.class[a11 - 1];
                a12 *= Math.pow(a7, a10);
                a9 += (a12 *= FunctionOps.combination(a8, a10));
            }
            double a13 = (double)a4.enum / (double)a6;
            a13 *= a7 * (double)a5.enum;
            a13 = Math.pow(a13, a8);
            this.class[a8 - 1] = a4.class[a8 - 1] + a5.class[a8 - 1] + a9 + (a13 *= 1.0 / Math.pow(a5.enum, a8 - 1) - Math.pow(-1.0 / (double)a4.enum, a8 - 1));
        }
        this.enum = a6;
    }

    @Override
    public long N() {
        return this.enum;
    }

    public double centralMoment(int k2) {
        ArgumentAssertion.assertTrue(k2 <= this.goto, "only up to the %d moment are available", this.goto);
        double a2 = this.class[k2 - 1] / (double)this.enum;
        return a2;
    }

    static {
        Package.validate("NMDEV_BASIC");
    }

    @Override
    public double value() {
        return this.centralMoment(this.goto);
    }

    public Moments(Moments that) {
        this.goto = that.goto;
        this.enum = that.enum;
        this.class = Arrays.copyOf(that.class, that.class.length);
    }

    public String toString() {
        StringBuilder a2 = new StringBuilder();
        for (int a3 = 0; a3 < this.class.length; ++a3) {
            a2.append(String.format("m[%d]: %f; ", a3, this.class[a3]));
        }
        return a2.toString();
    }

    public Moments(int order, double ... data) {
        this(order);
        this.addData(data);
    }

    public Moments(int order) {
        this.goto = order;
        this.class = new double[order];
    }

    public static double sumsOfPowersOfDifferences(int power, double mean, double ... data) {
        double a2 = 0.0;
        for (double a3 : data) {
            double a4 = a3 - mean;
            a2 += power == 1 ? a4 : Math.pow(a4, power);
        }
        return a2;
    }
}

