/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.descriptive.covariance;

import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.stat.descriptive.Statistic;
import dev.nm.stat.descriptive.moment.Variance;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Covariance
implements Statistic {
    private Variance void = new Variance();
    private double class = 0.0;
    private Variance goto = new Variance();
    private long enum = 0L;

    private void do(double[] a2, double[] a3) {
        Covariance a4;
        ArgumentAssertion.assertEqual(a2.length, a3.length, "data1's length", "data2's length");
        if (a4.enum == 0L) {
            a4.enum = a2.length;
            a4.void.addData(a2);
            a4.goto.addData(a3);
            double a5 = a4.void.mean();
            double a6 = a4.goto.mean();
            a4.class = 0.0;
            int a7 = 0;
            while ((long)a7 < a4.enum) {
                a4.class += (a2[a7] - a5) * (a3[a7] - a6);
                ++a7;
            }
            return;
        }
        Covariance a8 = new Covariance(a2, a3);
        long a9 = a4.enum + a8.enum;
        double a10 = a8.void.mean() - a4.void.mean();
        double a11 = a8.goto.mean() - a4.goto.mean();
        double a12 = (double)a4.enum / (double)a9 * (double)a8.enum;
        a4.class += a8.class + (a12 *= a10 * a11);
        a4.void.addData(a2);
        a4.goto.addData(a3);
        a4.enum = a9;
    }

    public Covariance(Covariance that) {
        this.enum = that.enum;
        this.void = that.void;
        this.goto = that.goto;
        this.class = that.class;
    }

    @Override
    public void addData(double ... data) {
        ArgumentAssertion.assertTrue(data.length % 2 == 0, "there must be an even number of data points", new Object[0]);
        int a2 = data.length / 2;
        double[] a3 = Arrays.copyOfRange(data, 0, a2);
        double[] a4 = Arrays.copyOfRange(data, a2, data.length);
        this.addData(a3, a4);
    }

    public String toString() {
        return String.format("covariance: %f; correlation: %f, N: %d", this.value(), this.correlation(), this.enum);
    }

    public double correlation() {
        return this.value() / this.void.standardDeviation() / this.goto.standardDeviation();
    }

    public void addData(double[] data1, double[] data2) {
        this.do(data1, data2);
    }

    public Covariance() {
    }

    @Override
    public double value() {
        return this.enum > 1L ? this.class / (double)(this.enum - 1L) : Double.NaN;
    }

    public Covariance(double[] data1, double[] data2) {
        this.do(data1, data2);
    }

    @Override
    public long N() {
        return this.enum;
    }

    static {
        Package.validate("NMDEV_BASIC");
    }
}

