/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.cointegration;

import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.stat.cointegration.CointegrationMLE;
import dev.nm.stat.cointegration.JohansenAsymptoticDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JohansenTest {
    private final JohansenAsymptoticDistribution.Test goto;
    private final JohansenAsymptoticDistribution[] enum;

    public JohansenTest(JohansenAsymptoticDistribution.Test test, JohansenAsymptoticDistribution.TrendType trend, int dim) {
        this(test, trend, dim, 500, 500);
    }

    public JohansenTest(JohansenAsymptoticDistribution.Test test, JohansenAsymptoticDistribution.TrendType trend, int dim, int nSim, int nT) {
        this.goto = test;
        this.enum = new JohansenAsymptoticDistribution[dim];
        for (int a2 = 0; a2 < dim; ++a2) {
            this.enum[a2] = new JohansenAsymptoticDistribution(test, trend, dim - a2, dim - a2 <= 2 ? Math.max(5000, nSim) : nSim, nT);
        }
    }

    public Vector getStats(CointegrationMLE coint) {
        double[] a2 = coint.getEigenvalues().toArray();
        int a3 = a2.length;
        int a4 = coint.n();
        double[] a5 = new double[a3];
        for (int a6 = 0; a6 < a3; ++a6) {
            if (this.goto == JohansenAsymptoticDistribution.Test.EIGEN) {
                a5[a6] = (double)(-a4) * Math.log(1.0 - a2[a6]);
                continue;
            }
            int a7 = a3 - a6 - 1;
            if (a6 == 0) {
                a5[a7] = (double)(-a4) * Math.log(1.0 - a2[a7]);
                continue;
            }
            a5[a7] = Math.log(1.0 - a2[a7]);
            int n = a7;
            a5[n] = a5[n] * (double)(-a4);
            int n2 = a7;
            a5[n2] = a5[n2] + a5[a3 - a6];
        }
        return new ImmutableVector(new DenseVector(a5));
    }

    public int r(CointegrationMLE coint, double level) {
        int a2;
        double a3 = 1.0 - level;
        double[] a4 = this.getStats(coint).toArray();
        for (a2 = 0; a2 < a4.length && !(a4[a2] < this.enum[a2].quantile(a3)); ++a2) {
        }
        return a2;
    }
}

