/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseVector;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixFactory;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.operation.VectorFactory;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.SOCPDualProblem1;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.SOCPGeneralConstraint;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.SOCPLinearEquality;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.SOCPLinearInequality;
import java.util.List;
import java.util.stream.IntStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * Duplicate member names - consider using --renamedupmembers true
 */
public class SOCPGeneralProblem1
extends SOCPDualProblem1 {
    public SOCPGeneralProblem1(Vector f2, SOCPGeneralConstraint[] generalConstraints, SOCPLinearInequality[] linearInequalities, SOCPLinearEquality[] linearEqualities) {
        super(f2, SOCPGeneralProblem1.do(generalConstraints), SOCPGeneralProblem1.do(generalConstraints), SOCPGeneralProblem1.do(linearInequalities), SOCPGeneralProblem1.do(linearInequalities), SOCPGeneralProblem1.do(linearEqualities), SOCPGeneralProblem1.do(linearEqualities));
        int a2 = f2.size();
        for (int a3 = 0; a3 < generalConstraints.length; ++a3) {
            Matrix a4 = generalConstraints[a3].A();
            ArgumentAssertion.assertTrue(a2 == a4.nRows(), "all A row sizes must match f's size", new Object[0]);
            Vector a5 = generalConstraints[a3].b();
            ArgumentAssertion.assertTrue(a2 == a5.size(), "all b sizes must match f's size", new Object[0]);
        }
    }

    public SOCPGeneralProblem1(Vector f2, List<SOCPGeneralConstraint> generalConstraints) {
        this(f2, generalConstraints.toArray(new SOCPGeneralConstraint[0]), null, null);
    }

    private static Vector do(SOCPLinearInequality[] a2) {
        if (a2 == null || a2.length == 0) {
            return null;
        }
        Vector[] a3 = new Vector[a2.length];
        for (int a4 = 0; a4 < a2.length; ++a4) {
            a3[a4] = a2[a4].c();
        }
        return VectorFactory.concat(a3);
    }

    private static Matrix[] do(SOCPGeneralConstraint[] a2) {
        int a3 = a2.length;
        Matrix[] a5 = new Matrix[a3];
        IntStream.range(0, a3).parallel().forEach(a4 -> {
            Matrix a5 = MatrixFactory.cbind(a2[a4].b());
            a3[a4] = MatrixFactory.cbind(a5, a2[a4].A());
        });
        return a5;
    }

    private static Vector[] do(SOCPGeneralConstraint[] a2) {
        int a3 = a2.length;
        Vector[] a4 = new Vector[a3];
        double[] a5 = new double[a3];
        for (int a6 = 0; a6 < a3; ++a6) {
            a4[a6] = a2[a6].c();
            a5[a6] = a2[a6].d();
        }
        Vector[] a7 = new Vector[a3];
        for (int a8 = 0; a8 < a3; ++a8) {
            a7[a8] = VectorFactory.concat(new SparseVector(a5[a8]), a4[a8]);
        }
        return a7;
    }

    public SOCPGeneralProblem1(Vector f2, List<SOCPGeneralConstraint> generalConstraints, List<SOCPLinearInequality> linearInequalities, List<SOCPLinearEquality> linearEqualities) {
        this(f2, generalConstraints.toArray(new SOCPGeneralConstraint[0]), linearInequalities != null ? linearInequalities.toArray(new SOCPLinearInequality[0]) : null, linearEqualities != null ? linearEqualities.toArray(new SOCPLinearEquality[0]) : null);
    }

    private static Matrix do(SOCPLinearEquality[] a2) {
        if (a2 == null || a2.length == 0) {
            return null;
        }
        Matrix[] a3 = new Matrix[a2.length];
        for (int a4 = 0; a4 < a2.length; ++a4) {
            a3[a4] = a2[a4].A();
        }
        return MatrixFactory.cbind(a3).opposite();
    }

    private static Matrix do(SOCPLinearInequality[] a2) {
        if (a2 == null || a2.length == 0) {
            return null;
        }
        Matrix[] a3 = new Matrix[a2.length];
        for (int a4 = 0; a4 < a2.length; ++a4) {
            a3[a4] = a2[a4].A();
        }
        return MatrixFactory.cbind(a3).opposite();
    }

    private static Vector do(SOCPLinearEquality[] a2) {
        if (a2 == null || a2.length == 0) {
            return null;
        }
        Vector[] a3 = new Vector[a2.length];
        for (int a4 = 0; a4 < a2.length; ++a4) {
            a3[a4] = a2[a4].c();
        }
        return VectorFactory.concat(a3);
    }

    public SOCPGeneralProblem1(SOCPGeneralProblem1 that) {
        super(that);
    }
}

