/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.number.complex;

import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import dev.nm.number.complex.Complex;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ElementaryFunction {
    public static Complex sin(Complex z) {
        ElementaryFunction.do(z);
        return new Complex(Math.sin(z.real()) * Math.cosh(z.imaginary()), Math.cos(z.real()) * Math.sinh(z.imaginary()));
    }

    public static Complex acos(Complex z) {
        ElementaryFunction.do(z);
        return new Complex(1.5707963267948966, 0.0).minus(ElementaryFunction.asin(z));
    }

    public static Complex asin(Complex z) {
        ElementaryFunction.do(z);
        return Complex.I.opposite().multiply(ElementaryFunction.log(Complex.I.multiply(z).add(ElementaryFunction.sqrt(((Complex)z.ONE()).minus(z.multiply(z))))));
    }

    public static Complex sqrt(Complex z) {
        double a2;
        ElementaryFunction.do(z);
        double a3 = Math.abs(z.real());
        double a4 = Math.abs(z.imaginary());
        if (DoubleUtils.isZero(z.real(), 0.0) && DoubleUtils.isZero(z.imaginary(), 0.0)) {
            return new Complex(0.0, 0.0);
        }
        if (a3 >= a4) {
            double a5 = a4 / a3;
            a2 = Math.sqrt(a3) * Math.sqrt((1.0 + Math.sqrt(1.0 + a5 * a5)) / 2.0);
        } else {
            double a6 = a3 / a4;
            a2 = Math.sqrt(a4) * Math.sqrt((a6 + Math.sqrt(1.0 + a6 * a6)) / 2.0);
        }
        Complex a7 = DoubleUtils.compare(z.real(), 0.0, 0.0) >= 0 ? new Complex(a2, z.imaginary() / a2 / 2.0) : (DoubleUtils.compare(z.imaginary(), 0.0, 0.0) >= 0 ? new Complex(a4 / a2 / 2.0, a2) : new Complex(a4 / a2 / 2.0, -a2));
        return a7;
    }

    public static Complex cos(Complex z) {
        ElementaryFunction.do(z);
        return new Complex(Math.cos(z.real()) * Math.cosh(z.imaginary()), -Math.sin(z.real()) * Math.sinh(z.imaginary()));
    }

    public static Complex tan(Complex z) {
        ElementaryFunction.do(z);
        double a2 = z.real() * 2.0;
        double a3 = z.imaginary() * 2.0;
        double a4 = Math.cos(a2) + Math.cosh(a3);
        return new Complex(Math.sin(a2) / a4, Math.sinh(a3) / a4);
    }

    public static Complex sinh(Complex z) {
        ElementaryFunction.do(z);
        return new Complex(Math.sinh(z.real()) * Math.cos(z.imaginary()), Math.cosh(z.real()) * Math.sin(z.imaginary()));
    }

    private static boolean do(Complex a2) {
        if (Complex.isNaN(a2) || Complex.isInfinite(a2)) {
            throw new IllegalArgumentException("this method is not defined for NaN or INFINITY");
        }
        return true;
    }

    public static Complex cosh(Complex z) {
        ElementaryFunction.do(z);
        return new Complex(Math.cosh(z.real()) * Math.cos(z.imaginary()), Math.sinh(z.real()) * Math.sin(z.imaginary()));
    }

    public static Complex pow(Complex z1, Complex z2) {
        ElementaryFunction.do(z1);
        ElementaryFunction.do(z2);
        double a2 = z1.modulus();
        if (DoubleUtils.isZero(a2, 0.0)) {
            return z1.ZERO();
        }
        double a3 = Math.atan2(z1.imaginary(), z1.real());
        return Complex.fromPolar(Math.pow(a2, z2.real()) / Math.exp(z2.imaginary() * a3), z2.imaginary() * Math.log(a2) + z2.real() * a3);
    }

    static {
        Package.validate("NMDEV_BASIC");
    }

    public static Complex tanh(Complex z) {
        ElementaryFunction.do(z);
        double a2 = z.real() * 2.0;
        double a3 = z.imaginary() * 2.0;
        double a4 = Math.cosh(a2) + Math.cos(a3);
        return new Complex(Math.sinh(a2) / a4, Math.sin(a3) / a4);
    }

    public static Complex atan(Complex z) {
        ElementaryFunction.do(z);
        return new Complex(0.0, 0.5).multiply(ElementaryFunction.log(Complex.ONE.minus(Complex.I.multiply(z))).minus(ElementaryFunction.log(Complex.ONE.add(Complex.I.multiply(z)))));
    }

    public static Complex exp(Complex z) {
        ElementaryFunction.do(z);
        double a2 = Math.exp(z.real());
        return Complex.fromPolar(a2, z.imaginary());
    }

    public static Complex log(Complex z) {
        ElementaryFunction.do(z);
        if (z.equals(z.ZERO())) {
            return Complex.NEGATIVE_INFINITY;
        }
        return new Complex(Math.log(z.modulus()), Math.atan2(z.imaginary(), z.real()));
    }
}

