/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.number;

import dev.nm.misc.license.Package;
import dev.nm.number.big.BigDecimalUtils;
import java.math.BigDecimal;
import java.math.BigInteger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ScientificNotation
extends Number {
    private final int class;
    private final BigDecimal goto;
    private final BigDecimal enum = BigDecimal.valueOf(10L);
    private static final long serialVersionUID = 1L;

    public BigDecimal bigDecimalValue() {
        BigDecimal a2 = BigDecimalUtils.pow(this.enum, this.class, Math.abs(this.class));
        BigDecimal a3 = this.goto.multiply(a2);
        a3.stripTrailingZeros();
        return a3;
    }

    public ScientificNotation(BigDecimal significand, int exponent) {
        this.goto = significand;
        this.class = exponent;
    }

    public ScientificNotation(double significand, int exponent) {
        this.goto = new BigDecimal(significand);
        this.class = exponent;
    }

    public ScientificNotation(BigDecimal x) {
        if (x.equals(BigDecimal.ZERO)) {
            this.goto = BigDecimal.ZERO;
            this.class = 0;
            return;
        }
        int a2 = 0;
        BigDecimal a3 = x.abs();
        while (a3.compareTo(this.enum) >= 0) {
            ++a2;
            a3 = a3.divide(this.enum);
        }
        while (a3.compareTo(BigDecimal.ONE) < 0) {
            --a2;
            a3 = a3.multiply(this.enum);
        }
        this.goto = x.signum() > 0 ? a3 : a3.negate();
        this.class = a2;
    }

    public ScientificNotation(long x) {
        this(BigInteger.valueOf(x));
    }

    @Override
    public long longValue() {
        return this.bigDecimalValue().longValue();
    }

    public int exponent() {
        return this.class;
    }

    @Override
    public int intValue() {
        return this.bigDecimalValue().intValue();
    }

    @Override
    public float floatValue() {
        return this.bigDecimalValue().floatValue();
    }

    @Override
    public double doubleValue() {
        return this.bigDecimalValue().doubleValue();
    }

    static {
        Package.validate("NMDEV_BASIC");
    }

    public ScientificNotation(BigInteger x) {
        this(new BigDecimal(x));
    }

    public ScientificNotation(double x) {
        this(new BigDecimal(x));
    }

    public BigDecimal significand() {
        return this.goto;
    }
}

