/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.root.univariate;

import dev.nm.analysis.differentiation.univariate.FiniteDifference;
import dev.nm.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import dev.nm.analysis.root.univariate.NoRootFoundException;
import dev.nm.analysis.root.univariate.Uniroot;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NewtonRoot
implements Uniroot {
    private final int goto;
    private final double enum;

    public NewtonRoot(double tol, int maxIterations) {
        this.enum = tol;
        this.goto = maxIterations;
    }

    public double solve(UnivariateRealFunction f2, UnivariateRealFunction df_, double guess) throws NoRootFoundException {
        double a2;
        UnivariateRealFunction a3 = df_ == null ? new FiniteDifference(f2, 1, FiniteDifference.Type.CENTRAL) : df_;
        double a4 = a2 = guess;
        double a5 = Double.POSITIVE_INFINITY;
        for (int a6 = 0; a6 < this.goto && Math.abs(a5) > this.enum; ++a6) {
            double a7 = f2.evaluate(a2);
            double a8 = a3.evaluate(a2);
            a4 = a2 - a7 / a8;
            double a9 = f2.evaluate(a4);
            a5 = a9 - a7;
            a2 = a4;
        }
        return a4;
    }

    public double solve(UnivariateRealFunction f2, double guess) throws NoRootFoundException {
        return this.solve(f2, null, guess);
    }

    @Override
    public double solve(UnivariateRealFunction f2, double lower, double upper, double ... guess) throws NoRootFoundException {
        return this.solve(f2, guess[0]);
    }
}

