/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.root.multivariate;

import dev.nm.algebra.linear.matrix.doubles.linearsystem.LinearSystemSolver;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.analysis.differentiation.multivariate.Jacobian;
import dev.nm.analysis.function.rn2r1.RealScalarFunction;
import dev.nm.analysis.function.rn2rm.RealVectorFunction;
import dev.nm.analysis.root.univariate.NoRootFoundException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NewtonSystemRoot {
    private final double goto;
    private final int enum;

    public NewtonSystemRoot(double accuracy, int maxIter) {
        this.goto = accuracy;
        this.enum = maxIter;
    }

    public Vector solve(final RealScalarFunction[] f2, Vector guess) throws NoRootFoundException {
        return this.solve(new RealVectorFunction(){

            @Override
            public Vector evaluate(Vector x) {
                int a2 = f2.length;
                DenseVector a3 = new DenseVector(a2);
                for (int a4 = 0; a4 < a2; ++a4) {
                    double a5 = (Double)f2[a4].evaluate(x);
                    a3.set(a4 + 1, a5);
                }
                return a3;
            }
            {
                1 a3;
            }

            @Override
            public int dimensionOfRange() {
                return f2.length;
            }

            @Override
            public int dimensionOfDomain() {
                return f2[0].dimensionOfDomain();
            }
        }, guess);
    }

    public Vector solve(RealVectorFunction f2, Vector guess) throws NoRootFoundException {
        LinearSystemSolver a2 = new LinearSystemSolver(this.goto);
        Vector a3 = guess;
        for (int a4 = 0; a4 < this.enum; ++a4) {
            Jacobian a5 = new Jacobian(f2, a3);
            LinearSystemSolver.Solution a6 = a2.solve(a5);
            Vector a7 = (Vector)f2.evaluate(a3);
            Vector a8 = a6.getParticularSolution(a7.scaled(-1.0));
            Vector a9 = a3.add(a8);
            double a10 = a9.minus(a3).norm();
            a3 = a9;
            if (a10 < this.goto) break;
        }
        return a3;
    }
}

