/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.function.polynomial.root;

import dev.nm.analysis.function.polynomial.Polynomial;
import dev.nm.analysis.function.polynomial.root.QuarticRoot;
import dev.nm.misc.PrecisionUtils;
import dev.nm.number.DoubleUtils;
import dev.nm.number.complex.Complex;
import dev.nm.number.complex.ElementaryFunction;
import java.util.ArrayList;
import java.util.List;

public class QuarticRootFerrari
implements QuarticRoot.QuarticSolver {
    private static final double enum = 0.3333333333333333;

    public List<Number> solve(Polynomial polynomial) {
        return this.solve(polynomial.getCoefficient(5), polynomial.getCoefficient(4), polynomial.getCoefficient(3), polynomial.getCoefficient(2), polynomial.getCoefficient(1));
    }

    @Override
    public List<Number> solve(double a2, double b2, double c2, double d2, double e2) {
        double a3 = PrecisionUtils.autoEpsilon(a2, b2, c2, d2, e2);
        return this.solve(a2, b2, c2, d2, e2, a3);
    }

    public List<Number> solve(double a2, double b2, double c2, double d2, double e2, double epsilon) {
        ArrayList<Number> a3 = new ArrayList<Number>();
        double a4 = a2 * a2;
        double a5 = a4 * a2;
        double a6 = a4 * a4;
        double a7 = b2 * b2;
        double a8 = a7 * b2;
        double a9 = a7 * a7;
        double a10 = b2 * c2;
        double a11 = a7 * c2;
        double a12 = -3.0 * a7 / 8.0 / a4 + c2 / a2;
        double a13 = a8 / 8.0 / a5 - a10 / 2.0 / a4 + d2 / a2;
        double a14 = -3.0 * a9 / 256.0 / a6 + a11 / 16.0 / a5 - b2 * d2 / 4.0 / a4 + e2 / a2;
        if (DoubleUtils.equal(a13, 0.0, epsilon)) {
            double a15 = a12 * a12 - 4.0 * a14;
            Complex a16 = new Complex(-b2 / a2 / 4.0, 0.0);
            Complex a17 = new Complex(-a12 / 2.0, 0.0);
            Complex a18 = ElementaryFunction.sqrt(new Complex(a15 / 4.0, 0.0));
            a3.add(a16.add(ElementaryFunction.sqrt(a17.add(a18))));
            a3.add(a16.add(ElementaryFunction.sqrt(a17.minus(a18))));
            a3.add(a16.minus(ElementaryFunction.sqrt(a17.add(a18))));
            a3.add(a16.minus(ElementaryFunction.sqrt(a17.minus(a18))));
        } else {
            double a19 = a12 * a12;
            double a20 = a19 * a12;
            double a21 = -a19 / 12.0 - a14;
            double a22 = -a20 / 108.0 + a12 * a14 / 3.0 - a13 * a13 / 8.0;
            double a23 = a21 * a21 * a21;
            double a24 = a22 * a22;
            Complex a25 = new Complex(-a22 / 2.0, 0.0).add(ElementaryFunction.sqrt(new Complex(a24 / 4.0 + a23 / 27.0, 0.0)));
            Complex a26 = ElementaryFunction.pow(a25, new Complex(0.3333333333333333, 0.0));
            Complex a27 = new Complex(-5.0 * a12 / 6.0, 0.0).add(a26).minus(a26.equals(a26.ZERO()) ? ElementaryFunction.pow(new Complex(a22, 0.0), new Complex(0.3333333333333333, 0.0)) : new Complex(a21 / 3.0, 0.0).divide(a26));
            Complex a28 = ElementaryFunction.sqrt(new Complex(a12, 0.0).add(new Complex(a27.real() * 2.0, a27.imaginary() * 2.0)));
            Complex a29 = new Complex(-b2 / 4.0 / a2, 0.0);
            Complex a30 = new Complex(a28.real() / 2.0, a28.imaginary() / 2.0);
            Complex a31 = new Complex(3.0 * a12 / 4.0 + a27.real() / 2.0, a27.imaginary() / 2.0);
            Complex a32 = new Complex(a13 / 2.0, 0.0).divide(a28);
            Complex a33 = ElementaryFunction.sqrt(a31.add(a32).opposite());
            Complex a34 = ElementaryFunction.sqrt(a31.minus(a32).opposite());
            a3.add(a29.add(a30).add(a33));
            a3.add(a29.add(a30).minus(a33));
            a3.add(a29.minus(a30).add(a34));
            a3.add(a29.minus(a30).minus(a34));
        }
        return a3;
    }
}

