/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.differentialequation.pde.finitedifference.hyperbolic.dim1;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.TridiagonalMatrix;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.analysis.differentialequation.pde.PDESolver;
import dev.nm.analysis.differentialequation.pde.finitedifference.PDESolutionTimeSpaceGrid1D;
import dev.nm.analysis.differentialequation.pde.finitedifference.hyperbolic.dim1.WaveEquation1D;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ExplicitCentralDifference1D
implements PDESolver {
    private static Matrix do(double a2, int a3) {
        double[] a4 = new double[a3];
        Arrays.fill(a4, 2.0 * (1.0 - a2));
        double[] a5 = new double[a3 - 1];
        Arrays.fill(a5, a2);
        return new TridiagonalMatrix(new double[][]{a5, a4, a5});
    }

    private static Vector short(WaveEquation1D a2, double[] a3) {
        int a4 = a3.length - 2;
        DenseVector a5 = new DenseVector(a4);
        for (int a6 = 1; a6 <= a4; ++a6) {
            a5.set(a6, a2.g(a3[a6]));
        }
        return a5;
    }

    static {
        Package.validate("NMDEV_OPDE");
    }

    public PDESolutionTimeSpaceGrid1D solve(WaveEquation1D pde, final int m2, final int n) {
        ArgumentAssertion.assertGreaterThan(m2, 1, "the number of time-axis grid points");
        ArgumentAssertion.assertGreaterThan(n, 1, "the number of space-axis grid points");
        final double[] a2 = DoubleUtils.seq(0.0, pde.T(), m2 + 1);
        final double[] a3 = DoubleUtils.seq(0.0, pde.a(), n + 2);
        final Vector[] a4 = new Vector[m2 + 1];
        double a5 = a2[1];
        double a6 = a3[1];
        a4[0] = new DenseVector(n);
        for (int a7 = 1; a7 <= n; ++a7) {
            a4[0].set(a7, pde.f(a3[a7]));
        }
        double a8 = pde.beta() * (a5 * a5) / (a6 * a6);
        Matrix a9 = ExplicitCentralDifference1D.do(a8, n);
        Vector a10 = ExplicitCentralDifference1D.do(pde, a3);
        Vector a11 = ExplicitCentralDifference1D.short(pde, a3);
        a4[1] = a9.multiply(a10).scaled(0.5).add(a11.scaled(a5));
        for (int a12 = 1; a12 < m2; ++a12) {
            a4[a12 + 1] = a9.multiply(a4[a12]).minus(a4[a12 - 1]);
        }
        return new PDESolutionTimeSpaceGrid1D(){

            @Override
            public int N() {
                return n;
            }

            @Override
            public double u(int k2, int j2) {
                ArgumentAssertion.assertRange(k2, 0, m2, "k");
                ArgumentAssertion.assertRange(j2, 0, n + 1, "j");
                if (j2 == 0 || j2 == n + 1) {
                    return 0.0;
                }
                return a4[k2].get(j2);
            }

            @Override
            public int M() {
                return m2;
            }
            {
                1 a32;
            }

            @Override
            public double t(int k2) {
                ArgumentAssertion.assertRange(k2, 0, m2, "k");
                return a2[k2];
            }

            @Override
            public double x(int j2) {
                ArgumentAssertion.assertRange(j2, 0, n + 1, "j");
                return a3[j2];
            }
        };
    }

    private static Vector do(WaveEquation1D a2, double[] a3) {
        int a4 = a3.length - 2;
        DenseVector a5 = new DenseVector(a4);
        for (int a6 = 1; a6 <= a4; ++a6) {
            a5.set(a6, a2.f(a3[a6]));
        }
        return a5;
    }
}

