/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.differentialequation.ode.ivp.solver.extrapolation;

import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.analysis.differentialequation.UnsatisfiableErrorCriterionException;
import dev.nm.analysis.differentialequation.ode.ivp.problem.DerivativeFunction;
import dev.nm.analysis.differentialequation.ode.ivp.problem.ODE1stOrder;
import dev.nm.analysis.differentialequation.ode.ivp.solver.ODESolution;
import dev.nm.analysis.differentialequation.ode.ivp.solver.ODESolver;
import dev.nm.misc.ArgumentAssertion;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BurlischStoerExtrapolation
implements ODESolver {
    private final double goto;
    private final int enum;

    public BurlischStoerExtrapolation(double epsilon, int maxIterations) {
        ArgumentAssertion.assertPositive(epsilon, "epsilon");
        ArgumentAssertion.assertNotLessThan(maxIterations, 2, "maximum number of iterations");
        this.goto = epsilon;
        this.enum = maxIterations;
    }

    @Override
    public ODESolution solve(ODE1stOrder ode) {
        double a2 = ode.x0();
        double a3 = ode.x1();
        DerivativeFunction a4 = ode.dy();
        Vector[] a5 = null;
        double a6 = 0.0;
        Vector[] a7 = null;
        boolean a8 = false;
        for (int a9 = 1; a9 <= this.enum; ++a9) {
            int a10;
            Vector[] a11 = new Vector[a9 + 1];
            int a12 = 1 << a9;
            a6 = (a3 - a2) / (double)a12;
            a7 = new Vector[a12 + 1];
            a7[0] = ode.y0();
            a7[1] = a7[0].add(a4.evaluate(a2, a7[0]).scaled(a6));
            for (a10 = 1; a10 < a12; ++a10) {
                a7[a10 + 1] = a7[a10 - 1].add(a4.evaluate(a2 + (double)a10 * a6, a7[a10]).scaled(a6 * 2.0));
            }
            a11[1] = a7[a12].add(a7[a12 - 1]).add(a4.evaluate(a3, a7[a12]).scaled(a6)).scaled(0.5);
            if (a9 > 1) {
                for (a10 = 2; a10 <= a9; ++a10) {
                    Vector a13;
                    double a14 = Math.pow(4.0, a10 - 1);
                    a11[a10] = a13 = a11[a10 - 1].scaled(a14).minus(a5[a10 - 1]).scaled(1.0 / (a14 - 1.0));
                }
                double a15 = Math.pow(4.0, a9 - 1);
                Vector a16 = a11[a9 - 1].minus(a5[a9 - 1]).scaled(1.0 / (a15 - 1.0));
                if (a16.norm() <= Math.max(a11[a9].norm(), 1.0) * this.goto) {
                    a8 = true;
                    break;
                }
            }
            a5 = a11;
        }
        if (!a8) {
            throw new UnsatisfiableErrorCriterionException();
        }
        double[] a17 = new double[a7.length];
        for (int a18 = 0; a18 < a17.length; ++a18) {
            a17[a18] = a2 + (double)a18 * a6;
        }
        return new ODESolution(a17, a7);
    }
}

