/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.curvefit.interpolation;

import dev.nm.analysis.curvefit.interpolation.OnlineInterpolator;
import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.analysis.function.rn2r1.univariate.StepFunction;
import dev.nm.analysis.function.tuple.DuplicatedAbscissae;
import dev.nm.analysis.function.tuple.OrderedPairs;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.number.DoubleUtils;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NevilleTable
extends AbstractUnivariateRealFunction
implements OnlineInterpolator {
    private double[][] catch;
    private double const;
    private static final double void = 1.2;
    private double[] class;
    private int goto;
    private int enum;

    public double[] x() {
        double[] a2 = Arrays.copyOf(this.class, this.enum);
        return a2;
    }

    public NevilleTable() {
        this(10, new StepFunction(0.0));
    }

    @Override
    public double evaluate(double x) {
        int a2;
        ArgumentAssertion.assertTrue(this.enum >= 2, "not enough data points for interpolation", new Object[0]);
        if (this.goto == this.enum - 1 && this.const == x) {
            return this.catch[0][this.goto];
        }
        int n = a2 = this.const == x ? this.goto : 1;
        while (a2 < this.enum) {
            for (int a3 = a2 - 1; a3 >= 0; --a3) {
                double a4 = (x - this.class[a2]) * this.catch[a3][a2 - 1];
                a4 += (this.class[a3] - x) * this.catch[a3 + 1][a2];
                double a5 = this.class[a3] - this.class[a2];
                if (DoubleUtils.isZero(a5, 0.0)) {
                    throw new DuplicatedAbscissae(String.format("x[%d] and x[%d] are identical", a3, a2));
                }
                this.catch[a3][a2] = a4 /= a5;
            }
            ++a2;
        }
        this.const = x;
        this.goto = this.enum - 1;
        return this.catch[0][this.goto];
    }

    public NevilleTable(OrderedPairs f2) {
        this(0, f2);
    }

    public double get(int i2, int j2) {
        ArgumentAssertion.assertTrue(j2 >= i2, "only the upper triangular part of the table is used", new Object[0]);
        return this.catch[i2][j2];
    }

    public double[][] getTable() {
        double[][] a2 = new double[this.enum][this.enum];
        for (int a3 = 0; a3 < this.enum; ++a3) {
            for (int a4 = a3; a4 < this.enum; ++a4) {
                a2[a3][a4] = this.catch[a3][a4];
            }
        }
        return a2;
    }

    public int N() {
        return this.enum;
    }

    @Override
    public void addData(OrderedPairs f2) {
        int a2;
        double[] a3 = f2.x();
        double[] a4 = f2.y();
        int a5 = a3.length;
        if (this.enum + a5 > this.catch.length) {
            a2 = (int)((double)(this.enum + a5) * 1.2);
            double[] a6 = new double[a2];
            for (int a7 = 0; a7 < this.enum; ++a7) {
                a6[a7] = this.class[a7];
            }
            this.class = a6;
            double[][] a8 = new double[a2][a2];
            for (int a9 = 0; a9 < this.enum; ++a9) {
                for (int a10 = a9; a10 < this.enum; ++a10) {
                    a8[a9][a10] = this.catch[a9][a10];
                }
            }
            this.catch = a8;
        }
        a2 = this.enum;
        for (int a11 = 0; a11 < a5; ++a11) {
            this.class[a2] = a3[a11];
            this.catch[a2][a2] = a4[a11];
            ++a2;
        }
        this.enum += a5;
    }

    public NevilleTable(int n, OrderedPairs f2) {
        int a2 = n;
        if (a2 < f2.size()) {
            a2 = (int)((double)f2.size() * 1.2);
        }
        this.class = new double[a2];
        this.catch = new double[a2][a2];
        this.addData(f2);
    }
}

