/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.stationary;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.linearsystem.LSProblem;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.ConvergenceFailure;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.IterativeLinearSystemSolver;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.stationary.SORSweep;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.algorithm.iterative.monitor.IterationMonitor;
import dev.nm.misc.algorithm.iterative.monitor.NullMonitor;
import dev.nm.misc.algorithm.iterative.tolerance.Tolerance;
import dev.nm.misc.datastructure.DimensionCheck;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SuccessiveOverrelaxationSolver
implements IterativeLinearSystemSolver {
    private final int class;
    private final double goto;
    private final Tolerance enum;

    public IterativeLinearSystemSolver.Solution solve(LSProblem problem) throws ConvergenceFailure {
        return this.solve(problem, new NullMonitor<Vector>());
    }

    public SuccessiveOverrelaxationSolver(double omega, int maxIteration, Tolerance tolerance) {
        this.goto = omega;
        this.class = maxIteration;
        this.enum = tolerance;
    }

    @Override
    public IterativeLinearSystemSolver.Solution solve(final LSProblem problem, final IterationMonitor<Vector> monitor) throws ConvergenceFailure {
        ArgumentAssertion.assertTrue(DimensionCheck.isSquare(problem.A()), "A must be a square matrix", new Object[0]);
        return new IterativeLinearSystemSolver.Solution(){
            private final Matrix catch;
            private Vector const;
            int count;
            private final Vector void;
            private boolean class;
            private final SORSweep goto;
            private Vector enum;

            public void setInitials(Vector ... initials) {
                this.enum = initials[0];
                this.const = this.void.minus(this.catch.multiply(this.enum));
                this.class = SuccessiveOverrelaxationSolver.this.enum.isResidualSmall(this.const.norm());
            }
            {
                1 a3;
                a3.catch = a3.problem.A();
                a3.void = a3.problem.b();
                a3.goto = new SORSweep(a3.catch, a3.void, a3.SuccessiveOverrelaxationSolver.this.goto);
                a3.count = 0;
            }

            @Override
            public IterationMonitor<Vector> step() throws ConvergenceFailure {
                monitor.addIterate(this.enum);
                this.enum = this.goto.forward(this.enum);
                this.const = this.void.minus(this.catch.multiply(this.enum));
                return monitor;
            }

            @Override
            public Vector search(Vector ... initials) throws ConvergenceFailure {
                this.setInitials(initials);
                while (this.count < SuccessiveOverrelaxationSolver.this.class && !this.class) {
                    this.step();
                    ++this.count;
                    this.class |= SuccessiveOverrelaxationSolver.this.enum.isResidualSmall(this.const.norm());
                }
                monitor.addIterate(this.enum);
                if (!this.class) {
                    throw new ConvergenceFailure(ConvergenceFailure.Reason.MAX_ITERATIONS_EXCEEDED, SuccessiveOverrelaxationSolver.this.class + " exceeded");
                }
                return this.enum;
            }
        };
    }
}

